/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.artifact.transfer.monitor;

public class ProgressSpinner {
    private static final String MESSAGE_PAD = " ";
    private final Style style;
    private int state = 0;

    public ProgressSpinner(Style style) {
        assert (style != null);
        this.style = style;
    }

    public ProgressSpinner() {
        this(new DefaultStyle());
    }

    public void reset() {
        this.state = 0;
    }

    public String spin() {
        return this.spin(null);
    }

    public String spin(String message) {
        StringBuilder buff = new StringBuilder();
        String[] elements = this.style.getElements();
        buff.append(this.style.getPrefix());
        buff.append(elements[this.state]);
        buff.append(this.style.getSuffix());
        if (message != null) {
            buff.append(MESSAGE_PAD);
            buff.append(message);
        }
        ++this.state;
        if (this.state >= elements.length) {
            this.state = 0;
        }
        return buff.toString();
    }

    public static class DefaultStyle
    implements Style {
        private static final String[] ELEMENTS = new String[]{"|", "/", "-", "\\"};

        public String getPrefix() {
            return "(";
        }

        public String[] getElements() {
            return ELEMENTS;
        }

        public String getSuffix() {
            return ")";
        }
    }

    public static interface Style {
        public String getPrefix();

        public String[] getElements();

        public String getSuffix();
    }
}

