/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.artifact.transfer.monitor;

import java.io.IOException;
import org.apache.geronimo.gshell.artifact.transfer.TransferEvent;
import org.apache.geronimo.gshell.artifact.transfer.TransferListenerSupport;
import org.apache.geronimo.gshell.artifact.transfer.monitor.ProgressSpinner;
import org.apache.geronimo.gshell.io.IO;

public class ProgressSpinnerMonitor
extends TransferListenerSupport {
    private static final String CARRIAGE_RETURN = "\r";
    private final IO io;
    private final ProgressSpinner spinner = new ProgressSpinner();
    private long complete;

    public ProgressSpinnerMonitor(IO io) throws IOException {
        assert (io != null);
        this.io = io;
    }

    private void print(String message) {
        if (!this.io.isQuiet()) {
            this.io.out.print(message);
            this.io.out.print(CARRIAGE_RETURN);
            this.io.out.flush();
        }
    }

    private void println(String message) {
        if (!this.io.isQuiet()) {
            this.io.out.println(message);
            this.io.out.flush();
        }
    }

    public void transferStarted(TransferEvent event) {
        assert (event != null);
        super.transferStarted(event);
        this.complete = 0L;
        this.spinner.reset();
        String type = this.renderRequestType(event);
        String location = event.getLocation();
        String message = type + ": " + location;
        this.println(message);
    }

    public void transferProgress(TransferEvent event) {
        assert (event != null);
        super.transferProgress(event);
        long total = event.getContentLength();
        this.complete += event.getLength();
        String message = this.renderProgressBytes(this.complete, total);
        this.print(this.spinner.spin(message));
    }

    public void transferCompleted(TransferEvent event) {
        assert (event != null);
        super.transferCompleted(event);
        long total = event.getContentLength();
        String type = this.renderRequestTypeFinished(event);
        String bytes = this.renderBytes(total);
        this.print(type + " " + bytes + "          ");
    }
}

