/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.clp;

import org.apache.geronimo.gshell.clp.Descriptor;
import org.apache.geronimo.gshell.clp.Option;

public class OptionDescriptor
extends Descriptor {
    private final String name;
    private final String[] aliases;
    private final boolean argumentRequired;
    private final boolean requireOverride;

    public OptionDescriptor(String id, Option option, boolean forceMultiValued) {
        super(id, option.description(), option.token(), option.required(), option.handler(), option.multiValued() || forceMultiValued);
        this.name = option.name();
        this.aliases = option.aliases();
        this.argumentRequired = option.argumentRequired();
        this.requireOverride = option.requireOverride();
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public boolean isArgumentRequired() {
        return this.argumentRequired;
    }

    public boolean isRequireOverride() {
        return this.requireOverride;
    }

    public String toString() {
        if (this.aliases != null && this.aliases.length > 0) {
            String str = "";
            for (String alias : this.aliases) {
                if (str.length() > 0) {
                    str = str + ", ";
                }
                str = str + alias;
            }
            return this.getName() + " (" + str + ")";
        }
        return this.getName();
    }
}

