/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.clp;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.geronimo.gshell.clp.ArgumentDescriptor;
import org.apache.geronimo.gshell.clp.CommandLineProcessor;
import org.apache.geronimo.gshell.clp.Descriptor;
import org.apache.geronimo.gshell.clp.handler.Handler;
import org.apache.geronimo.gshell.i18n.MessageSource;
import org.apache.geronimo.gshell.i18n.ResourceBundleMessageSource;
import org.apache.geronimo.gshell.i18n.ResourceNotFoundException;

public class Printer {
    private CommandLineProcessor processor;
    private MessageSource printerMessages = new ResourceBundleMessageSource(Printer.class);
    private MessageSource messages;

    public Printer(CommandLineProcessor processor) {
        assert (processor != null);
        this.processor = processor;
    }

    public void setMessageSource(MessageSource messages) {
        assert (messages != null);
        this.messages = messages;
    }

    private String getHelpText(Descriptor descriptor) {
        assert (descriptor != null);
        String message = descriptor.getDescription();
        if (this.messages != null) {
            String code = message;
            if (code == null) {
                code = descriptor instanceof ArgumentDescriptor ? "argument." + descriptor.getId() : "option." + descriptor.getId();
            }
            try {
                message = this.messages.getMessage(code);
            }
            catch (ResourceNotFoundException e) {
                // empty catch block
            }
        }
        return message;
    }

    private String getToken(Handler handler) {
        assert (handler != null);
        Descriptor descriptor = handler.descriptor;
        String token = descriptor.getToken();
        if (this.messages != null) {
            String code = token;
            if (code == null) {
                code = descriptor instanceof ArgumentDescriptor ? "argument." + descriptor.getId() + ".token" : "option." + descriptor.getId() + ".token";
            }
            try {
                token = this.messages.getMessage(code);
            }
            catch (ResourceNotFoundException e) {
                // empty catch block
            }
        }
        if (token == null) {
            token = handler.getDefaultToken();
        }
        return token;
    }

    private String getNameAndToken(Handler handler) {
        assert (handler != null);
        String str = handler.descriptor instanceof ArgumentDescriptor ? "" : handler.descriptor.toString();
        String token = this.getToken(handler);
        if (token != null) {
            if (str.length() > 0) {
                str = str + " ";
            }
            str = str + token;
        }
        return str;
    }

    private int getPrefixLen(Handler handler) {
        assert (handler != null);
        String helpText = this.getHelpText(handler.descriptor);
        if (helpText == null) {
            return 0;
        }
        return this.getNameAndToken(handler).length();
    }

    public void printUsage(Writer writer, String name) {
        int curLen;
        assert (writer != null);
        PrintWriter out = new PrintWriter(writer);
        ArrayList<Handler> argumentHandlers = new ArrayList<Handler>();
        argumentHandlers.addAll(this.processor.getArgumentHandlers());
        ArrayList<Handler> optionHandlers = new ArrayList<Handler>();
        optionHandlers.addAll(this.processor.getOptionHandlers());
        Collections.sort(optionHandlers, new Comparator<Handler>(){

            @Override
            public int compare(Handler a, Handler b) {
                return a.descriptor.toString().compareTo(b.descriptor.toString());
            }
        });
        if (name != null) {
            String syntax = this.printerMessages.format("syntax", name);
            if (!optionHandlers.isEmpty()) {
                syntax = this.printerMessages.format("syntax.hasOptions", syntax);
            }
            if (!argumentHandlers.isEmpty()) {
                syntax = this.printerMessages.format("syntax.hasArguments", syntax);
            }
            out.println(syntax);
            out.println();
        }
        int len = 0;
        for (Handler handler : optionHandlers) {
            curLen = this.getPrefixLen(handler);
            len = Math.max(len, curLen);
        }
        for (Handler handler : argumentHandlers) {
            curLen = this.getPrefixLen(handler);
            len = Math.max(len, curLen);
        }
        if (!argumentHandlers.isEmpty()) {
            out.println(this.printerMessages.getMessage("arguments.header"));
            for (Handler handler : argumentHandlers) {
                this.printHandler(out, handler, len);
            }
            out.println();
        }
        if (!optionHandlers.isEmpty()) {
            out.println(this.printerMessages.getMessage("options.header"));
            for (Handler handler : optionHandlers) {
                this.printHandler(out, handler, len);
            }
            out.println();
        }
        out.flush();
    }

    public void printUsage(Writer writer) {
        this.printUsage(writer, null);
    }

    private void printHandler(PrintWriter out, Handler handler, int len) {
        int i;
        assert (out != null);
        assert (handler != null);
        int terminalWidth = 80;
        String prefix = "  ";
        String separator = "    ";
        int prefixSeperatorWidth = prefix.length() + separator.length();
        int descriptionWidth = terminalWidth - len - prefixSeperatorWidth;
        String desc = this.getHelpText(handler.descriptor);
        if (desc == null) {
            return;
        }
        String nameAndToken = this.getNameAndToken(handler);
        out.print(prefix);
        out.print(nameAndToken);
        for (i = nameAndToken.length(); i < len; ++i) {
            out.print(' ');
        }
        out.print(separator);
        while (desc != null && desc.length() > 0) {
            i = desc.indexOf(10);
            if (i >= 0 && i <= descriptionWidth) {
                out.println(desc.substring(0, i));
                if ((desc = desc.substring(i + 1)).length() <= 0) continue;
                this.indent(out, len + prefixSeperatorWidth);
                continue;
            }
            if (desc.length() <= descriptionWidth) {
                out.println(desc);
                break;
            }
            out.println(desc.substring(0, descriptionWidth));
            desc = desc.substring(descriptionWidth);
            this.indent(out, len + prefixSeperatorWidth);
        }
    }

    private void indent(PrintWriter out, int i) {
        assert (out != null);
        while (i > 0) {
            out.print(' ');
            --i;
        }
    }
}

