/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.clp.handler;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.gshell.clp.Descriptor;
import org.apache.geronimo.gshell.clp.IllegalAnnotationError;
import org.apache.geronimo.gshell.clp.handler.BooleanHandler;
import org.apache.geronimo.gshell.clp.handler.DoubleHandler;
import org.apache.geronimo.gshell.clp.handler.EnumHandler;
import org.apache.geronimo.gshell.clp.handler.FileHandler;
import org.apache.geronimo.gshell.clp.handler.Handler;
import org.apache.geronimo.gshell.clp.handler.IntegerHandler;
import org.apache.geronimo.gshell.clp.handler.LongHandler;
import org.apache.geronimo.gshell.clp.handler.ObjectHandler;
import org.apache.geronimo.gshell.clp.handler.StringHandler;
import org.apache.geronimo.gshell.clp.handler.UriHandler;
import org.apache.geronimo.gshell.clp.setter.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handlers {
    private static final Map<Class, Constructor<? extends Handler>> handlerClasses = Collections.synchronizedMap(new HashMap());

    private static Constructor<? extends Handler> createHandlerFactory(Class<? extends Handler> type) {
        assert (type != null);
        try {
            return type.getConstructor(Descriptor.class, Setter.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Handler is missing required constructor: " + type);
        }
    }

    private static Constructor<? extends Handler> getHandlerFactory(Class type) {
        assert (type != null);
        Constructor<? extends Handler> factory = handlerClasses.get(type);
        if (factory == null) {
            throw new IllegalAnnotationError("No handler registered for type: " + type);
        }
        return factory;
    }

    public static Handler create(Descriptor desc, Setter setter) {
        Constructor<? extends Handler> factory;
        assert (desc != null);
        assert (setter != null);
        Class<? extends Handler> handlerType = desc.getHandler();
        if (handlerType == Handler.class) {
            Class valueType = setter.getType();
            if (Enum.class.isAssignableFrom(valueType)) {
                return new EnumHandler(desc, setter, valueType);
            }
            factory = Handlers.getHandlerFactory(valueType);
        } else {
            factory = Handlers.createHandlerFactory(handlerType);
        }
        try {
            return factory.newInstance(desc, setter);
        }
        catch (InstantiationException e) {
            throw new IllegalAnnotationError(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAnnotationError(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalAnnotationError(e);
        }
    }

    public static void register(Class valueType, Class<? extends Handler> handlerType) {
        assert (valueType != null);
        assert (handlerType != null);
        assert (Handler.class.isAssignableFrom(handlerType));
        Constructor<? extends Handler> factory = Handlers.createHandlerFactory(handlerType);
        handlerClasses.put(valueType, factory);
    }

    static {
        Handlers.register(Boolean.class, BooleanHandler.class);
        Handlers.register(Boolean.TYPE, BooleanHandler.class);
        Handlers.register(File.class, FileHandler.class);
        Handlers.register(URI.class, UriHandler.class);
        Handlers.register(Integer.class, IntegerHandler.class);
        Handlers.register(Integer.TYPE, IntegerHandler.class);
        Handlers.register(Long.class, LongHandler.class);
        Handlers.register(Long.TYPE, LongHandler.class);
        Handlers.register(Double.class, DoubleHandler.class);
        Handlers.register(Double.TYPE, DoubleHandler.class);
        Handlers.register(String.class, StringHandler.class);
        Handlers.register(Object.class, ObjectHandler.class);
    }
}

