/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.builtin;

import org.apache.geronimo.gshell.application.Application;
import org.apache.geronimo.gshell.application.model.ApplicationModel;
import org.apache.geronimo.gshell.application.model.Branding;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.io.IO;

public class AboutAction
implements CommandAction {
    private final Application application;

    public AboutAction(Application application) {
        assert (application != null);
        this.application = application;
    }

    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        ApplicationModel model = this.application.getModel();
        Branding branding = this.application.getModel().getBranding();
        String id = this.application.getId();
        String name = model.getName();
        if (name == null) {
            io.info("{}", id);
        } else {
            io.info("{} ({})", name, id);
        }
        io.info("{}", model.getVersion());
        io.out.println();
        io.out.println(branding.getAboutMessage());
        return CommandAction.Result.SUCCESS;
    }
}

