/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.builtin;

import java.util.Collection;
import org.apache.geronimo.gshell.ansi.AnsiCode;
import org.apache.geronimo.gshell.ansi.AnsiRenderer;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.i18n.MessageSource;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.registry.AliasRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasAction
implements CommandAction {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AliasRegistry aliasRegistry;
    @Argument(index=0)
    private String name;
    @Argument(index=1)
    private String target;

    public AliasAction(AliasRegistry aliasRegistry) {
        assert (aliasRegistry != null);
        this.aliasRegistry = aliasRegistry;
    }

    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        if (this.name == null) {
            return this.listAliases(context);
        }
        return this.defineAlias(context);
    }

    private Object listAliases(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        this.log.debug("Listing defined aliases");
        Collection<String> names = this.aliasRegistry.getAliasNames();
        if (names.isEmpty()) {
            io.info("No aliases have been defined");
        } else {
            int maxNameLen = 0;
            for (String name : names) {
                if (name.length() <= maxNameLen) continue;
                maxNameLen = name.length();
            }
            io.out.println("Defined aliases:");
            for (String name : names) {
                String alias = this.aliasRegistry.getAlias(name);
                String formattedName = String.format("%-" + maxNameLen + "s", name);
                io.out.print("  ");
                io.out.print(AnsiRenderer.encode(formattedName, AnsiCode.BOLD));
                io.out.print("  ");
                io.out.print("Alias to: ");
                io.out.println(alias);
            }
        }
        return CommandAction.Result.SUCCESS;
    }

    private Object defineAlias(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        if (this.target == null) {
            MessageSource messages = context.getCommand().getMessages();
            io.error("Missing argument: {}", messages.getMessage("command.argument.target.token"));
            return CommandAction.Result.FAILURE;
        }
        this.log.debug("Defining alias: {} -> {}", (Object)this.name, (Object)this.target);
        this.aliasRegistry.registerAlias(this.name, this.target);
        return CommandAction.Result.SUCCESS;
    }
}

