/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.builtin;

import java.util.Iterator;
import java.util.Properties;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.i18n.MessageSource;
import org.apache.geronimo.gshell.io.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetAction
implements CommandAction {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-m", aliases={"--mode"})
    private Mode mode = Mode.VARIABLE;
    @Option(name="-v", aliases={"--verbose"})
    private boolean verbose;
    @Argument(index=0)
    private String name;
    @Argument(index=1)
    private String value;

    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        MessageSource messages = context.getCommand().getMessages();
        if (this.name == null) {
            return this.displayList(context);
        }
        if (this.value == null) {
            io.error("Missing required argument: {}", messages.getMessage("command.argument.value.token"));
            return CommandAction.Result.FAILURE;
        }
        switch (this.mode) {
            case PROPERTY: {
                this.log.debug("Setting system property: {}={}", (Object)this.name, (Object)this.value);
                System.setProperty(this.name, this.value);
                break;
            }
            case VARIABLE: {
                Variables vars = context.getVariables();
                this.log.info("Setting variable: {}={}", (Object)this.name, (Object)this.value);
                vars.parent().set(this.name, this.value);
            }
        }
        return CommandAction.Result.SUCCESS;
    }

    private Object displayList(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        switch (this.mode) {
            case PROPERTY: {
                Properties props = System.getProperties();
                for (Object o : props.keySet()) {
                    String name = (String)o;
                    String value = props.getProperty(name);
                    io.outputStream.print(name);
                    io.outputStream.print("='");
                    io.outputStream.print(value);
                    io.outputStream.print("'");
                    io.outputStream.println();
                }
                break;
            }
            case VARIABLE: {
                Variables variables = context.getVariables();
                Iterator<String> iter = variables.names();
                while (iter.hasNext()) {
                    String name = iter.next();
                    if (name.startsWith("gshell.internal")) continue;
                    Object value = variables.get(name);
                    io.outputStream.print(name);
                    io.outputStream.print("='");
                    io.outputStream.print(value);
                    io.outputStream.flush();
                    io.outputStream.print("'");
                    if (this.verbose && value != null) {
                        io.outputStream.print(" (");
                        io.outputStream.print(value.getClass());
                        io.outputStream.print(")");
                    }
                    io.outputStream.println();
                }
                break;
            }
        }
        io.outputStream.flush();
        return CommandAction.Result.SUCCESS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        VARIABLE,
        PROPERTY;

    }
}

