/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.builtin;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.commons.vfs.FileObject;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.commandline.CommandLineExecutor;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.shell.ShellContextHolder;
import org.apache.geronimo.gshell.vfs.FileSystemAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceAction
implements CommandAction {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CommandLineExecutor executor;
    private final FileSystemAccess fileSystemAccess;
    @Argument(required=true)
    private String path;

    public SourceAction(CommandLineExecutor executor, FileSystemAccess fileSystemAccess) {
        assert (executor != null);
        this.executor = executor;
        assert (fileSystemAccess != null);
        this.fileSystemAccess = fileSystemAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        FileObject cwd = this.fileSystemAccess.getCurrentDirectory(context.getVariables());
        FileObject file = this.fileSystemAccess.resolveFile(cwd, this.path);
        if (!file.exists()) {
            io.error("File not found: {}", file.getName());
            return CommandAction.Result.FAILURE;
        }
        if (!file.getType().hasContent()) {
            io.error("File has no content: {}", file.getName());
            return CommandAction.Result.FAILURE;
        }
        this.log.debug("Sourcing file: {}", (Object)file.getName());
        BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContent().getInputStream()));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String tmp = line.trim();
                if (tmp.length() == 0 || tmp.startsWith("#")) continue;
                this.executor.execute(ShellContextHolder.get(), line);
            }
        }
        finally {
            reader.close();
            file.close();
        }
        return CommandAction.Result.SUCCESS;
    }
}

