/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.builtin;

import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.command.Variables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsetAction
implements CommandAction {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-m", aliases={"--mode"})
    private Mode mode = Mode.VARIABLE;
    @Argument(required=true)
    private List<String> args = null;

    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        Variables variables = context.getVariables();
        for (String arg : this.args) {
            String namevalue = String.valueOf(arg);
            switch (this.mode) {
                case PROPERTY: {
                    this.unsetProperty(namevalue);
                    break;
                }
                case VARIABLE: {
                    this.unsetVariable(variables, namevalue);
                }
            }
        }
        return CommandAction.Result.SUCCESS;
    }

    private void unsetProperty(String name) {
        this.log.info("Unsetting system property: {}", (Object)name);
        System.getProperties().remove(name);
    }

    private void unsetVariable(Variables vars, String name) {
        this.log.info("Unsetting variable: {}", (Object)name);
        vars.parent().unset(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        VARIABLE,
        PROPERTY;

    }
}

