/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.file;

import java.security.cert.Certificate;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileContentInfo;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.vfs.FileObjects;
import org.apache.geronimo.gshell.vfs.support.VfsActionSupport;

public class FileInfoAction
extends VfsActionSupport {
    @Argument(required=true)
    private String path;

    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        FileObject file = this.resolveFile(context, this.path);
        io.info("URL: {}", file.getURL());
        io.info("Name: {}", file.getName());
        io.info("BaseName: {}", file.getName().getBaseName());
        io.info("Extension: {}", file.getName().getExtension());
        io.info("Path: {}", file.getName().getPath());
        io.info("Scheme: {}", file.getName().getScheme());
        io.info("URI: {}", file.getName().getURI());
        io.info("Root URI: {}", file.getName().getRootURI());
        io.info("Parent: {}", file.getName().getParent());
        io.info("Type: {}", file.getType());
        io.info("Exists: {}", file.exists());
        io.info("Readable: {}", file.isReadable());
        io.info("Writeable: {}", file.isWriteable());
        io.info("Root path: {}", file.getFileSystem().getRoot().getName().getPath());
        if (file.exists()) {
            FileContent content = file.getContent();
            FileContentInfo contentInfo = content.getContentInfo();
            io.info("Content type: {}", contentInfo.getContentType());
            io.info("Content encoding: {}", contentInfo.getContentEncoding());
            try {
                Map attrs = content.getAttributes();
                if (attrs != null && !attrs.isEmpty()) {
                    io.info("Attributes:");
                    for (Map.Entry entry : attrs.entrySet()) {
                        io.info("    {}='{}'", entry.getKey(), entry.getValue());
                    }
                }
            }
            catch (FileSystemException e) {
                io.info("File attributes are NOT supported");
            }
            try {
                Certificate[] certs = content.getCertificates();
                if (certs != null && certs.length != 0) {
                    io.info("Certificate:");
                    for (Certificate cert : certs) {
                        io.info("    {}", cert);
                    }
                }
            }
            catch (FileSystemException e) {
                io.info("File certificates are NOT supported");
            }
            if (file.getType().equals(FileType.FILE)) {
                io.info("Size: {} bytes", content.getSize());
            } else if (file.getType().hasChildren() && file.isReadable()) {
                FileObject[] children = file.getChildren();
                io.info("Directory with {} files", children.length);
                for (int iterChildren = 0; iterChildren < children.length; ++iterChildren) {
                    io.info("#{}:{}", iterChildren, children[iterChildren].getName());
                    if (iterChildren > 5) break;
                }
            }
            io.info("Last modified: {}", DateFormat.getInstance().format(new Date(content.getLastModifiedTime())));
        } else {
            io.info("The file does not exist");
        }
        FileObjects.close(file);
        return CommandAction.Result.SUCCESS;
    }
}

