/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.file;

import java.util.ArrayList;
import java.util.LinkedList;
import jline.ConsoleReader;
import org.apache.commons.vfs.FileFilter;
import org.apache.commons.vfs.FileFilterSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.vfs.FileObjects;
import org.apache.geronimo.gshell.vfs.support.VfsActionSupport;

public class ListDirectoryAction
extends VfsActionSupport {
    @Argument
    private String path;
    @Option(name="-l", aliases={"--long"})
    private boolean longList;
    @Option(name="-a", aliases={"--all"})
    private boolean includeHidden;
    @Option(name="-r", aliases={"--recursive"})
    private boolean recursive;

    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        FileObject file = this.path != null ? this.resolveFile(context, this.path) : this.getCurrentDirectory(context);
        if (file.getType().hasChildren()) {
            this.listChildren(io, file);
        } else {
            io.info(file.getName().getPath());
        }
        FileObjects.close(file);
        return CommandAction.Result.SUCCESS;
    }

    private void listChildren(IO io, FileObject dir) throws Exception {
        FileObject[] files;
        assert (io != null);
        assert (dir != null);
        if (this.includeHidden) {
            files = dir.getChildren();
        } else {
            FileFilter filter = new FileFilter(){

                public boolean accept(FileSelectInfo selection) {
                    assert (selection != null);
                    try {
                        return !selection.getFile().isHidden();
                    }
                    catch (FileSystemException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            files = dir.findFiles((FileSelector)new FileFilterSelector(filter));
        }
        ConsoleReader reader = io.createConsoleReader();
        reader.setUsePagination(false);
        ArrayList<String> names = new ArrayList<String>(files.length);
        LinkedList<FileObject> dirs = new LinkedList<FileObject>();
        for (FileObject file : files) {
            String fileName = file.getName().getBaseName();
            if (FileObjects.hasChildren(file)) {
                fileName = fileName + "/";
                if (this.recursive) {
                    dirs.add(file);
                }
            }
            names.add(fileName);
            file.close();
        }
        if (this.longList) {
            for (String name : names) {
                io.out.println(name);
            }
        } else {
            reader.printColumns(names);
        }
        if (!dirs.isEmpty()) {
            for (FileObject subdir : dirs) {
                io.out.println();
                io.out.print(subdir.getName().getBaseName());
                io.out.print(":");
                this.listChildren(io, subdir);
            }
        }
        dir.close();
    }
}

