/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.ssh;

import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.i18n.MessageSource;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.spring.BeanContainer;
import org.apache.geronimo.gshell.spring.BeanContainerAware;
import org.apache.sshd.SshServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshServerAction
implements CommandAction,
BeanContainerAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-p", aliases={"--port"})
    private int port = 8101;
    @Option(name="-b", aliases={"--background"})
    private boolean background = true;
    private BeanContainer container;

    public void setBeanContainer(BeanContainer container) {
        assert (container != null);
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        IO io = context.getIo();
        MessageSource messages = context.getCommand().getMessages();
        SshServer server = this.container.getBean("sshServer", SshServer.class);
        this.log.debug("Created server: {}", (Object)server);
        server.setPort(this.port);
        server.start();
        io.info(messages.format("info.listening", this.port));
        if (!this.background) {
            SshServerAction sshServerAction = this;
            synchronized (sshServerAction) {
                this.log.debug("Waiting for server to shutdown");
                this.wait();
            }
            server.stop();
        }
        return CommandAction.Result.SUCCESS;
    }
}

