/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.text;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs.FileObject;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.io.Closer;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.vfs.FileObjects;
import org.apache.geronimo.gshell.vfs.support.VfsActionSupport;
import org.apache.oro.text.MatchAction;
import org.apache.oro.text.MatchActionInfo;
import org.apache.oro.text.MatchActionProcessor;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class GrepAction
extends VfsActionSupport {
    public static final int FOUND = 0;
    public static final int NOT_FOUND = 1;
    @Argument(index=0, required=true)
    private String pattern;
    @Argument(index=1, required=false)
    private String path;
    @Option(name="-c", aliases={"--count"})
    private boolean count;
    @Option(name="-i", aliases={"--ignore-case"})
    private boolean ignoreCase;
    @Option(name="-n", aliases={"--line-number"})
    private boolean lineNumbers;
    @Option(name="-v", aliases={"--invert-match"})
    private boolean invertMatch;
    private int matches = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        final IO io = context.getIo();
        Perl5Compiler compiler = new Perl5Compiler();
        InvertableMatcher matcher = new InvertableMatcher((PatternMatcher)new Perl5Matcher());
        MatchActionProcessor processor = new MatchActionProcessor((PatternCompiler)compiler, (PatternMatcher)matcher);
        try {
            int options = 0;
            if (this.ignoreCase) {
                options = 1;
            }
            processor.addAction(this.pattern, options, new MatchAction(){

                public void processMatch(MatchActionInfo info) {
                    GrepAction.this.matches++;
                    if (!GrepAction.this.count) {
                        StringBuilder buff = new StringBuilder();
                        if (GrepAction.this.lineNumbers) {
                            buff.append(info.lineNumber);
                            buff.append(":");
                        }
                        buff.append(info.line);
                        io.info(buff.toString());
                    }
                }
            });
        }
        catch (MalformedPatternException e) {
            io.error("Invalid pattern: " + (Object)((Object)e), new Object[]{e});
            return CommandAction.Result.FAILURE;
        }
        if (this.path != null) {
            FileObject file = this.resolveFile(context, this.path);
            try {
                this.grep(context, processor, file);
            }
            finally {
                FileObjects.close(file);
            }
        } else {
            processor.processMatches(context.getIo().inputStream, (OutputStream)context.getIo().outputStream);
        }
        if (this.count) {
            io.info("{}", this.matches);
        }
        return this.matches != 0 ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grep(CommandContext context, MatchActionProcessor processor, FileObject file) throws Exception {
        assert (context != null);
        assert (processor != null);
        assert (file != null);
        this.ensureFileExists(file);
        this.ensureFileHasContent(file);
        this.ensureFileIsReadable(file);
        BufferedInputStream input = new BufferedInputStream(file.getContent().getInputStream());
        try {
            processor.processMatches((InputStream)input, (OutputStream)context.getIo().outputStream);
        }
        catch (Throwable throwable) {
            Closer.close(input);
            throw throwable;
        }
        Closer.close(input);
    }

    private final class InvertableMatcher
    implements PatternMatcher {
        private final PatternMatcher delegate;

        public InvertableMatcher(PatternMatcher delegate) {
            this.delegate = delegate;
        }

        public boolean matchesPrefix(char[] input, Pattern pattern, int offset) {
            boolean result = this.delegate.matchesPrefix(input, pattern, offset);
            return GrepAction.this.invertMatch ? !result : result;
        }

        public boolean matchesPrefix(String input, Pattern pattern) {
            boolean result = this.delegate.matchesPrefix(input, pattern);
            return GrepAction.this.invertMatch ? !result : result;
        }

        public boolean matchesPrefix(char[] input, Pattern pattern) {
            boolean result = this.delegate.matchesPrefix(input, pattern);
            return GrepAction.this.invertMatch ? !result : result;
        }

        public boolean matchesPrefix(PatternMatcherInput input, Pattern pattern) {
            boolean result = this.delegate.matchesPrefix(input, pattern);
            return GrepAction.this.invertMatch ? !result : result;
        }

        public boolean matches(String input, Pattern pattern) {
            boolean result = this.delegate.matches(input, pattern);
            return GrepAction.this.invertMatch ? !result : result;
        }

        public boolean matches(char[] input, Pattern pattern) {
            boolean result = this.delegate.matches(input, pattern);
            return GrepAction.this.invertMatch ? !result : result;
        }

        public boolean matches(PatternMatcherInput input, Pattern pattern) {
            boolean result = this.delegate.matches(input, pattern);
            return GrepAction.this.invertMatch ? !result : result;
        }

        public boolean contains(String input, Pattern pattern) {
            boolean result = this.delegate.contains(input, pattern);
            return GrepAction.this.invertMatch ? !result : result;
        }

        public boolean contains(char[] input, Pattern pattern) {
            boolean result = this.delegate.contains(input, pattern);
            return GrepAction.this.invertMatch ? !result : result;
        }

        public boolean contains(PatternMatcherInput input, Pattern pattern) {
            boolean result = this.delegate.contains(input, pattern);
            return GrepAction.this.invertMatch ? !result : result;
        }

        public MatchResult getMatch() {
            return this.delegate.getMatch();
        }
    }
}

