/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.text;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.io.Closer;
import org.apache.geronimo.gshell.vfs.FileObjects;
import org.apache.geronimo.gshell.vfs.support.VfsActionSupport;

public class SortAction
extends VfsActionSupport {
    @Option(name="-f")
    private boolean caseInsensitive;
    @Option(name="-r")
    private boolean reverse;
    @Option(name="-u")
    private boolean unique;
    @Option(name="-t")
    private String separator;
    @Option(name="-b")
    private boolean ignoreBlanks;
    @Option(name="-k", argumentRequired=true, multiValued=true)
    private List<String> sortFields;
    @Option(name="-n")
    private boolean numeric;
    @Argument(index=0, required=false)
    private String path;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(CommandContext context) throws Exception {
        assert (context != null);
        if (this.path != null) {
            FileObject file = this.resolveFile(context, this.path);
            try {
                this.sort(context, file);
            }
            finally {
                FileObjects.close(file);
            }
        } else {
            this.sort(context.getIo().inputStream, context.getIo().out);
        }
        return CommandAction.Result.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sort(CommandContext context, FileObject file) throws Exception {
        assert (context != null);
        assert (file != null);
        this.ensureFileExists(file);
        this.ensureFileHasContent(file);
        this.ensureFileIsReadable(file);
        BufferedInputStream input = new BufferedInputStream(file.getContent().getInputStream());
        try {
            this.sort(input, context.getIo().out);
        }
        catch (Throwable throwable) {
            Closer.close(input);
            throw throwable;
        }
        Closer.close(input);
    }

    protected void sort(InputStream input, PrintWriter out) throws Exception {
        BufferedReader r = new BufferedReader(new InputStreamReader(input));
        ArrayList<String> strings = new ArrayList<String>();
        String s = r.readLine();
        while (s != null) {
            strings.add(s);
            s = r.readLine();
        }
        char sep = this.separator == null || this.separator.length() == 0 ? (char)'\u0000' : this.separator.charAt(0);
        Collections.sort(strings, new SortComparator(this.caseInsensitive, this.reverse, this.ignoreBlanks, this.numeric, sep, this.sortFields));
        String last = null;
        for (String s2 : strings) {
            if (last == null) {
                last = s2;
                continue;
            }
            if (this.unique && s2.equals(last)) continue;
            out.println(s2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortComparator
    implements Comparator<String> {
        private boolean caseInsensitive;
        private boolean reverse;
        private boolean ignoreBlanks;
        private boolean numeric;
        private char separator;
        private List<Key> sortKeys;
        private static Pattern fpPattern;

        public SortComparator(boolean caseInsensitive, boolean reverse, boolean ignoreBlanks, boolean numeric, char separator, List<String> sortFields) {
            this.caseInsensitive = caseInsensitive;
            this.reverse = reverse;
            this.separator = separator;
            this.ignoreBlanks = ignoreBlanks;
            this.numeric = numeric;
            if (sortFields == null || sortFields.size() == 0) {
                sortFields = new ArrayList<String>();
                sortFields.add("1");
            }
            this.sortKeys = new ArrayList<Key>();
            for (String f : sortFields) {
                this.sortKeys.add(new Key(f));
            }
        }

        @Override
        public int compare(String o1, String o2) {
            int res = 0;
            List<Integer> fi1 = this.getFieldIndexes(o1);
            List<Integer> fi2 = this.getFieldIndexes(o2);
            for (Key key : this.sortKeys) {
                int[] k1 = this.getSortKey(o1, fi1, key);
                int[] k2 = this.getSortKey(o2, fi2, key);
                if (key.numeric) {
                    Double d1 = this.getDouble(o1, k1[0], k1[1]);
                    Double d2 = this.getDouble(o2, k2[0], k2[1]);
                    res = d1.compareTo(d2);
                } else {
                    res = this.compareRegion(o1, k1[0], k1[1], o2, k2[0], k2[1], key.caseInsensitive);
                }
                if (res == 0) continue;
                if (!key.reverse) break;
                res = -res;
                break;
            }
            return res;
        }

        protected Double getDouble(String s, int start, int end) {
            Matcher m = fpPattern.matcher(s.substring(start, end));
            m.find();
            return new Double(s.substring(0, m.end(1)));
        }

        protected int compareRegion(String s1, int start1, int end1, String s2, int start2, int end2, boolean caseInsensitive) {
            int n1 = end1;
            int n2 = end2;
            int i1 = start1;
            for (int i2 = start2; i1 < end1 && i2 < n2; ++i1, ++i2) {
                char c2;
                char c1 = s1.charAt(i1);
                if (c1 == (c2 = s2.charAt(i2))) continue;
                if (caseInsensitive) {
                    if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                    return c1 - c2;
                }
                return c1 - c2;
            }
            return n1 - n2;
        }

        protected int[] getSortKey(String str, List<Integer> fields, Key key) {
            int end;
            int start;
            if (key.startField * 2 < fields.size()) {
                if (key.ignoreBlanksStart) {
                    for (start = fields.get((key.startField - 1) * 2).intValue(); start < fields.get((key.startField - 1) * 2 + 1) && Character.isWhitespace(str.charAt(start)); ++start) {
                    }
                }
                if (key.startChar > 0) {
                    start = Math.min(start + key.startChar - 1, fields.get((key.startField - 1) * 2 + 1));
                }
            } else {
                start = 0;
            }
            if (key.endField > 0 && key.endField * 2 < fields.size()) {
                if (key.ignoreBlanksEnd) {
                    for (end = fields.get((key.endField - 1) * 2).intValue(); end < fields.get((key.endField - 1) * 2 + 1) && Character.isWhitespace(str.charAt(end)); ++end) {
                    }
                }
                if (key.endChar > 0) {
                    end = Math.min(end + key.endChar - 1, fields.get((key.endField - 1) * 2 + 1));
                }
            } else {
                end = str.length();
            }
            return new int[]{start, end};
        }

        protected List<Integer> getFieldIndexes(String o) {
            ArrayList<Integer> fields = new ArrayList<Integer>();
            if (o.length() > 0) {
                if (this.separator == '\u0000') {
                    boolean i = false;
                    fields.add(0);
                    for (int idx = 1; idx < o.length(); ++idx) {
                        if (!Character.isWhitespace(o.charAt(idx)) || Character.isWhitespace(o.charAt(idx - 1))) continue;
                        fields.add(idx - 1);
                        fields.add(idx);
                    }
                    fields.add(o.length() - 1);
                } else {
                    int last = -1;
                    int idx = o.indexOf(this.separator);
                    while (idx >= 0) {
                        if (last >= 0) {
                            fields.add(last);
                            fields.add(idx - 1);
                        } else if (idx > 0) {
                            fields.add(0);
                            fields.add(idx - 1);
                        }
                        last = idx + 1;
                        idx = o.indexOf(this.separator, idx + 1);
                    }
                    if (last < o.length()) {
                        fields.add(last < 0 ? 0 : last);
                        fields.add(o.length() - 1);
                    }
                }
            }
            return fields;
        }

        static {
            String Digits = "(\\p{Digit}+)";
            String HexDigits = "(\\p{XDigit}+)";
            String Exp = "[eE][+-]?(\\p{Digit}+)";
            String fpRegex = "([\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*)(.*)";
            fpPattern = Pattern.compile("([\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*)(.*)");
        }

        public class Key {
            int startField;
            int startChar;
            int endField;
            int endChar;
            boolean ignoreBlanksStart;
            boolean ignoreBlanksEnd;
            boolean caseInsensitive;
            boolean reverse;
            boolean numeric;

            public Key(String str) {
                boolean modifiers = false;
                boolean startPart = true;
                boolean inField = true;
                boolean inChar = false;
                block9: for (char c : str.toCharArray()) {
                    switch (c) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (!inField && !inChar) {
                                throw new IllegalArgumentException("Bad field syntax: " + str);
                            }
                            if (startPart) {
                                if (inChar) {
                                    this.startChar = this.startChar * 10 + (c - 48);
                                    continue block9;
                                }
                                this.startField = this.startField * 10 + (c - 48);
                                continue block9;
                            }
                            if (inChar) {
                                this.endChar = this.endChar * 10 + (c - 48);
                                continue block9;
                            }
                            this.endField = this.endField * 10 + (c - 48);
                            continue block9;
                        }
                        case '.': {
                            if (!inField) {
                                throw new IllegalArgumentException("Bad field syntax: " + str);
                            }
                            inField = false;
                            inChar = true;
                            continue block9;
                        }
                        case 'n': {
                            inField = false;
                            inChar = false;
                            modifiers = true;
                            this.numeric = true;
                            continue block9;
                        }
                        case 'f': {
                            inField = false;
                            inChar = false;
                            modifiers = true;
                            this.caseInsensitive = true;
                            continue block9;
                        }
                        case 'r': {
                            inField = false;
                            inChar = false;
                            modifiers = true;
                            this.reverse = true;
                            continue block9;
                        }
                        case 'b': {
                            inField = false;
                            inChar = false;
                            modifiers = true;
                            if (startPart) {
                                this.ignoreBlanksStart = true;
                                continue block9;
                            }
                            this.ignoreBlanksEnd = true;
                            continue block9;
                        }
                        case ',': {
                            inField = true;
                            inChar = false;
                            startPart = false;
                            continue block9;
                        }
                        default: {
                            throw new IllegalArgumentException("Bad field syntax: " + str);
                        }
                    }
                }
                if (!modifiers) {
                    this.ignoreBlanksStart = this.ignoreBlanksEnd = SortComparator.this.ignoreBlanks;
                    this.reverse = SortComparator.this.reverse;
                    this.caseInsensitive = SortComparator.this.caseInsensitive;
                    this.numeric = SortComparator.this.numeric;
                }
                if (this.startField < 1) {
                    throw new IllegalArgumentException("Bad field syntax: " + str);
                }
            }
        }
    }
}

