/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.console.completer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import jline.Completor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateCompleter
implements Completor {
    private final List<Completor> completers = new ArrayList<Completor>();

    public AggregateCompleter() {
    }

    public AggregateCompleter(Collection<Completor> completers) {
        assert (completers != null);
        this.getCompleters().addAll(completers);
    }

    public Collection<Completor> getCompleters() {
        return this.completers;
    }

    public int complete(String buffer, int cursor, List candidates) {
        assert (candidates != null);
        ArrayList<Completion> completions = new ArrayList<Completion>(this.completers.size());
        int max = -1;
        for (Completor completer : this.completers) {
            Completion completion = new Completion(candidates);
            completion.complete(completer, buffer, cursor);
            max = Math.max(max, completion.cursor);
            completions.add(completion);
        }
        for (Completion completion : completions) {
            if (completion.cursor != max) continue;
            candidates.addAll(completion.candidates);
        }
        return max;
    }

    private class Completion {
        public final List<String> candidates;
        public int cursor;

        public Completion(List candidates) {
            assert (candidates != null);
            this.candidates = new LinkedList<String>(candidates);
        }

        public void complete(Completor completer, String buffer, int cursor) {
            assert (completer != null);
            this.cursor = completer.complete(buffer, cursor, this.candidates);
        }
    }
}

