/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.event;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.geronimo.gshell.event.Event;
import org.apache.geronimo.gshell.event.EventListener;
import org.apache.geronimo.gshell.event.EventManager;
import org.apache.geronimo.gshell.event.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManagerImpl
implements EventManager,
EventPublisher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<EventListener> listeners = new LinkedHashSet<EventListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(EventListener listener) {
        assert (listener != null);
        this.log.trace("Adding listener: {}", (Object)listener);
        Set<EventListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListneer(EventListener listener) {
        assert (listener != null);
        this.log.trace("Removing listener: {}", (Object)listener);
        Set<EventListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public EventPublisher getPublisher() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Event event) {
        EventListener[] targets;
        assert (event != null);
        this.log.trace("Publishing event: {}", (Object)event);
        Set<EventListener> set = this.listeners;
        synchronized (set) {
            targets = this.listeners.toArray(new EventListener[this.listeners.size()]);
        }
        for (EventListener listener : targets) {
            this.log.trace("Firing event ({}) to listener: {}", (Object)event, (Object)listener);
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {
                this.log.error("Listener handler raised an exception", (Throwable)e);
            }
        }
    }
}

