/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.geronimo.gshell.i18n.MessageSource;
import org.apache.geronimo.gshell.i18n.ResourceNotFoundException;

public class ResourceBundleMessageSource
implements MessageSource {
    private final List<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
    private final Locale locale;

    public ResourceBundleMessageSource(Class[] types) {
        assert (types != null);
        this.locale = Locale.getDefault();
        for (Class type : types) {
            this.loadBundle(type);
        }
    }

    public ResourceBundleMessageSource(Class type) {
        this(new Class[]{type});
    }

    private void loadBundle(Class type) {
        assert (type != null);
        ResourceBundle bundle = ResourceBundle.getBundle(type.getName(), this.locale, type.getClassLoader());
        this.bundles.add(bundle);
    }

    public String getMessage(String code) {
        assert (code != null);
        for (ResourceBundle bundle : this.bundles) {
            try {
                return bundle.getString(code);
            }
            catch (MissingResourceException ignore) {
            }
        }
        throw new ResourceNotFoundException(code);
    }

    public String format(String code, Object ... args) {
        assert (args != null);
        String pattern = this.getMessage(code);
        return String.format(pattern, args);
    }
}

