/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.gshell.spring.BeanContainerContext;
import org.apache.geronimo.gshell.spring.BeanContainerContextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.beans.support.ResourceEditorRegistrar;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.ObjectUtils;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanContainerContextSupport
extends DefaultResourceLoader
implements BeanContainerContext,
DisposableBean {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String id = ObjectUtils.identityToString((Object)this);
    private final BeanContainerContext parent;
    private final List<BeanFactoryPostProcessor> beanFactoryPostProcessors = new ArrayList<BeanFactoryPostProcessor>();
    private boolean active = false;
    private final Object activeMonitor = new Object();
    private final Object startupShutdownMonitor = new Object();
    private final Thread shutdownHook;
    private final ResourcePatternResolver resourcePatternResolver;
    private DefaultListableBeanFactory beanFactory;
    private final Object beanFactoryMonitor = new Object();

    public BeanContainerContextSupport() {
        this(null);
    }

    public BeanContainerContextSupport(BeanContainerContext parent) {
        this.parent = parent;
        this.resourcePatternResolver = new PathMatchingResourcePatternResolver((ResourceLoader)this);
        this.shutdownHook = new Thread(){

            public void run() {
                BeanContainerContextSupport.this.doClose();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public BeanContainerContext getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws BeansException, IllegalStateException {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            Object object2 = this.activeMonitor;
            synchronized (object2) {
                this.active = true;
            }
            this.log.debug("Refreshing: {}", (Object)this);
            ConfigurableListableBeanFactory beanFactory = this.obtainFreshBeanFactory();
            this.prepareBeanFactory(beanFactory);
            try {
                this.invokeBeanFactoryPostProcessors(beanFactory);
                this.registerBeanPostProcessors(beanFactory);
                this.finishBeanFactoryInitialization(beanFactory);
            }
            catch (BeansException e) {
                this.log.error("Refresh failed", (Throwable)e);
                beanFactory.destroySingletons();
                Object object3 = this.activeMonitor;
                synchronized (object3) {
                    this.active = false;
                }
                throw e;
            }
        }
    }

    private ConfigurableListableBeanFactory obtainFreshBeanFactory() {
        this.refreshBeanFactory();
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        this.log.info("Bean factory for application context [{}]: {}", (Object)this.getId(), (Object)ObjectUtils.identityToString((Object)beanFactory));
        this.log.debug("{} beans defined in {}", (Object)beanFactory.getBeanDefinitionCount(), (Object)this);
        return beanFactory;
    }

    private void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        assert (beanFactory != null);
        beanFactory.setBeanClassLoader(this.getClassLoader());
        beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)new ResourceEditorRegistrar((ResourceLoader)this));
        beanFactory.registerResolvableDependency(BeanFactory.class, (Object)beanFactory);
        beanFactory.registerResolvableDependency(ResourceLoader.class, (Object)this);
        beanFactory.registerResolvableDependency(BeanContainerContext.class, (Object)this);
    }

    private void finishBeanFactoryInitialization(ConfigurableListableBeanFactory beanFactory) {
        assert (beanFactory != null);
        beanFactory.setTempClassLoader(null);
        beanFactory.freezeConfiguration();
        beanFactory.preInstantiateSingletons();
    }

    @Override
    public void addBeanFactoryPostProcessor(BeanFactoryPostProcessor beanFactoryPostProcessor) {
        this.beanFactoryPostProcessors.add(beanFactoryPostProcessor);
    }

    private void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        assert (beanFactory != null);
        for (BeanFactoryPostProcessor factoryProcessor : this.beanFactoryPostProcessors) {
            factoryProcessor.postProcessBeanFactory(beanFactory);
        }
        String[] postProcessorNames = beanFactory.getBeanNamesForType(BeanFactoryPostProcessor.class, true, false);
        ArrayList<BeanFactoryPostProcessor> priorityOrderedPostProcessors = new ArrayList<BeanFactoryPostProcessor>();
        ArrayList<String> orderedPostProcessorNames = new ArrayList<String>();
        ArrayList<String> nonOrderedPostProcessorNames = new ArrayList<String>();
        for (String name : postProcessorNames) {
            if (this.isTypeMatch(name, PriorityOrdered.class)) {
                priorityOrderedPostProcessors.add((BeanFactoryPostProcessor)beanFactory.getBean(name));
                continue;
            }
            if (this.isTypeMatch(name, Ordered.class)) {
                orderedPostProcessorNames.add(name);
                continue;
            }
            nonOrderedPostProcessorNames.add(name);
        }
        Collections.sort(priorityOrderedPostProcessors, new OrderComparator());
        this.invokeBeanFactoryPostProcessors(beanFactory, priorityOrderedPostProcessors);
        ArrayList<BeanFactoryPostProcessor> orderedPostProcessors = new ArrayList<BeanFactoryPostProcessor>();
        for (String name : orderedPostProcessorNames) {
            orderedPostProcessors.add((BeanFactoryPostProcessor)this.getBean(name));
        }
        Collections.sort(orderedPostProcessors, new OrderComparator());
        this.invokeBeanFactoryPostProcessors(beanFactory, orderedPostProcessors);
        ArrayList<BeanFactoryPostProcessor> nonOrderedPostProcessors = new ArrayList<BeanFactoryPostProcessor>();
        for (String name : nonOrderedPostProcessorNames) {
            nonOrderedPostProcessors.add((BeanFactoryPostProcessor)this.getBean(name));
        }
        this.invokeBeanFactoryPostProcessors(beanFactory, nonOrderedPostProcessors);
    }

    private void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory, List<BeanFactoryPostProcessor> postProcessors) {
        assert (beanFactory != null);
        assert (postProcessors != null);
        for (BeanFactoryPostProcessor postProcessor : postProcessors) {
            postProcessor.postProcessBeanFactory(beanFactory);
        }
    }

    private void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        assert (beanFactory != null);
        String[] postProcessorNames = beanFactory.getBeanNamesForType(BeanPostProcessor.class, true, false);
        int beanProcessorTargetCount = beanFactory.getBeanPostProcessorCount() + 1 + postProcessorNames.length;
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new BeanPostProcessorChecker(beanFactory, beanProcessorTargetCount));
        ArrayList<BeanPostProcessor> priorityOrderedPostProcessors = new ArrayList<BeanPostProcessor>();
        ArrayList<String> orderedPostProcessorNames = new ArrayList<String>();
        ArrayList<String> nonOrderedPostProcessorNames = new ArrayList<String>();
        for (String name : postProcessorNames) {
            if (this.isTypeMatch(name, PriorityOrdered.class)) {
                priorityOrderedPostProcessors.add((BeanPostProcessor)beanFactory.getBean(name));
                continue;
            }
            if (this.isTypeMatch(name, Ordered.class)) {
                orderedPostProcessorNames.add(name);
                continue;
            }
            nonOrderedPostProcessorNames.add(name);
        }
        Collections.sort(priorityOrderedPostProcessors, new OrderComparator());
        this.registerBeanPostProcessors(beanFactory, priorityOrderedPostProcessors);
        ArrayList<BeanPostProcessor> orderedPostProcessors = new ArrayList<BeanPostProcessor>();
        for (String name : orderedPostProcessorNames) {
            orderedPostProcessors.add((BeanPostProcessor)this.getBean(name));
        }
        Collections.sort(orderedPostProcessors, new OrderComparator());
        this.registerBeanPostProcessors(beanFactory, orderedPostProcessors);
        ArrayList<BeanPostProcessor> nonOrderedPostProcessors = new ArrayList<BeanPostProcessor>();
        for (String name : nonOrderedPostProcessorNames) {
            nonOrderedPostProcessors.add((BeanPostProcessor)this.getBean(name));
        }
        this.registerBeanPostProcessors(beanFactory, nonOrderedPostProcessors);
    }

    private void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, List<BeanPostProcessor> postProcessors) {
        assert (beanFactory != null);
        assert (postProcessors != null);
        for (BeanPostProcessor postProcessor : postProcessors) {
            beanFactory.addBeanPostProcessor(postProcessor);
        }
    }

    public void destroy() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            this.doClose();
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() {
        if (this.isActive()) {
            this.log.info("Closing: {}", (Object)this);
            this.destroyBeans();
            this.closeBeanFactory();
            Object object = this.activeMonitor;
            synchronized (object) {
                this.active = false;
            }
        }
    }

    private void destroyBeans() {
        this.getBeanFactory().destroySingletons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.activeMonitor;
        synchronized (object) {
            return this.active;
        }
    }

    public Object getBean(String name) throws BeansException {
        return this.getBeanFactory().getBean(name);
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        return this.getBeanFactory().getBean(name, requiredType);
    }

    public Object getBean(String name, Object[] args) throws BeansException {
        return this.getBeanFactory().getBean(name, args);
    }

    public boolean containsBean(String name) {
        return this.getBeanFactory().containsBean(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isSingleton(name);
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isPrototype(name);
    }

    public boolean isTypeMatch(String name, Class targetType) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isTypeMatch(name, targetType);
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().getType(name);
    }

    public String[] getAliases(String name) {
        return this.getBeanFactory().getAliases(name);
    }

    public boolean containsBeanDefinition(String name) {
        return this.getBeanFactory().containsBeanDefinition(name);
    }

    public int getBeanDefinitionCount() {
        return this.getBeanFactory().getBeanDefinitionCount();
    }

    public String[] getBeanDefinitionNames() {
        return this.getBeanFactory().getBeanDefinitionNames();
    }

    public String[] getBeanNamesForType(Class type) {
        return this.getBeanFactory().getBeanNamesForType(type);
    }

    public String[] getBeanNamesForType(Class type, boolean includePrototypes, boolean allowEagerInit) {
        return this.getBeanFactory().getBeanNamesForType(type, includePrototypes, allowEagerInit);
    }

    public Map getBeansOfType(Class type) throws BeansException {
        return this.getBeanFactory().getBeansOfType(type);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean allowEagerInit) throws BeansException {
        return this.getBeanFactory().getBeansOfType(type, includePrototypes, allowEagerInit);
    }

    public BeanFactory getParentBeanFactory() {
        return this.getParent();
    }

    public boolean containsLocalBean(String name) {
        return this.getBeanFactory().containsLocalBean(name);
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        return this.resourcePatternResolver.getResources(locationPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshBeanFactory() throws BeansException {
        if (this.hasBeanFactory()) {
            this.destroyBeans();
            this.closeBeanFactory();
        }
        try {
            DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory(this.getParent() != null ? this.getParent().getBeanFactory() : null);
            beanFactory.setAllowBeanDefinitionOverriding(true);
            beanFactory.setAllowCircularReferences(true);
            beanFactory.setAllowEagerClassLoading(false);
            this.loadBeanDefinitions(beanFactory);
            Object object = this.beanFactoryMonitor;
            synchronized (object) {
                this.beanFactory = beanFactory;
            }
        }
        catch (IOException e) {
            throw new BeanContainerContextException("I/O error parsing XML document for application context: " + this, e);
        }
    }

    private void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        assert (beanFactory != null);
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        reader.setResourceLoader((ResourceLoader)this);
        reader.setEntityResolver((EntityResolver)new ResourceEntityResolver((ResourceLoader)this));
        reader.setNamespaceAware(true);
        reader.setValidationMode(0);
        this.loadBeanDefinitions(reader);
    }

    protected abstract void loadBeanDefinitions(XmlBeanDefinitionReader var1) throws BeansException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeBeanFactory() {
        Object object = this.beanFactoryMonitor;
        synchronized (object) {
            this.beanFactory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasBeanFactory() {
        Object object = this.beanFactoryMonitor;
        synchronized (object) {
            return this.beanFactory != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ConfigurableListableBeanFactory getBeanFactory() {
        Object object = this.beanFactoryMonitor;
        synchronized (object) {
            if (this.beanFactory == null) {
                throw new IllegalStateException("BeanFactory not initialized or already closed");
            }
            return this.beanFactory;
        }
    }

    private class BeanPostProcessorChecker
    implements BeanPostProcessor {
        private final ConfigurableListableBeanFactory beanFactory;
        private final int beanPostProcessorTargetCount;

        public BeanPostProcessorChecker(ConfigurableListableBeanFactory beanFactory, int beanPostProcessorTargetCount) {
            assert (beanFactory != null);
            this.beanFactory = beanFactory;
            this.beanPostProcessorTargetCount = beanPostProcessorTargetCount;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            assert (bean != null);
            assert (beanName != null);
            if (!(bean instanceof BeanPostProcessor) && this.beanFactory.getBeanPostProcessorCount() < this.beanPostProcessorTargetCount) {
                BeanContainerContextSupport.this.log.info("Bean '{}' is not eligible for getting processed by all BeanPostProcessors (for example: not eligible for auto-proxying)", (Object)beanName);
            }
            return bean;
        }
    }
}

