/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.spring;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.LookupOverride;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.beans.factory.support.MethodOverrides;
import org.springframework.beans.factory.support.ReplaceOverride;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LoggingProcessor
implements BeanFactoryPostProcessor,
Ordered {
    public static final int DEFAULT_INDENT_SIZE = 4;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean prettyPrint = true;
    private int indentSize = 4;
    private boolean sortBeansByName = false;
    private MetadataElementDescriptionCreator metadataElementDescriptionCreator = MetadataElementDescriptionCreator.DUMMY;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.log.isTraceEnabled()) {
            try {
                String xml = this.render(beanFactory);
                this.log.trace("Bean factory contents:\n{}", (Object)xml);
            }
            catch (Exception e) {
                this.log.error("Failed to render bean factory contents", (Throwable)e);
            }
        }
    }

    public String render(ConfigurableListableBeanFactory beanFactory) throws Exception {
        StringWriter writer = new StringWriter();
        Document document = this.generateBeanFactoryDump(beanFactory);
        if (document != null) {
            this.writeDocument(document, writer);
        }
        return writer.toString();
    }

    private void writeDocument(Document document, Writer writer) throws TransformerException, IOException {
        assert (document != null);
        assert (writer != null);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (this.prettyPrint) {
            try {
                transformerFactory.setAttribute("indent-number", this.indentSize);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(writer);
        if (this.prettyPrint) {
            try {
                transformer.setOutputProperty("indent", "yes");
                String indentSize = Integer.toString(this.indentSize);
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", indentSize);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        transformer.transform(source, result);
    }

    private Document generateBeanFactoryDump(ConfigurableListableBeanFactory beanFactory) throws ParserConfigurationException {
        assert (beanFactory != null);
        Document result = this.createDocument();
        ElementBuilder builder = new ElementBuilder(result);
        this.generateRoot(builder);
        this.generateBeanAliases(beanFactory, builder);
        this.generateBeanDefinitions(beanFactory, builder);
        result.getDocumentElement().normalize();
        return result;
    }

    private void processBeanDefinition(String beanName, BeanDefinition beanDefinition, ElementBuilder builder, boolean inHolder) {
        this.generateBeanDefinitionAttributes(beanDefinition, builder, beanName, inHolder);
        this.generateConstructorArguments(beanDefinition, builder);
        this.generateProperties(beanDefinition, builder);
        this.generateLookupMethods(beanDefinition, builder);
        builder.up();
    }

    private void generateProperties(BeanDefinition beanDefinition, ElementBuilder builder) {
        MutablePropertyValues properties = beanDefinition.getPropertyValues();
        List list = properties.getPropertyValueList();
        for (PropertyValue property : list) {
            this.generatePropertyElement(beanDefinition, builder, property);
        }
    }

    private void generatePropertyElement(BeanDefinition beanDefinition, ElementBuilder builder, PropertyValue property) {
        builder.addChild("property");
        String propertyName = property.getName();
        builder.addAttribute("name", propertyName);
        String description = this.metadataElementDescriptionCreator.getPropertyValueBeanDefinitionDescription(beanDefinition, property);
        if (description != null) {
            builder.addChild("description");
            builder.addPCData(description);
            builder.up();
        }
        Object value = property.getValue();
        this.processValue(value, builder, false, false);
        builder.up();
    }

    private void generateBeanDefinitionAttributes(BeanDefinition beanDefinition, ElementBuilder elementBuilder, String beanName, boolean inHolder) {
        String description;
        ChildBeanDefinition childBeanDefinition;
        String parent;
        String beanClassName = beanDefinition.getBeanClassName();
        boolean isAbstract = beanDefinition.isAbstract();
        boolean isLazyInit = beanDefinition.isLazyInit();
        String scope = beanDefinition.getScope();
        ElementBuilder builder = elementBuilder.addChild("bean");
        if (!inHolder && beanName != null && !beanName.equals(beanClassName)) {
            if (this.isBeanNameApplicableForID(beanName)) {
                builder.addAttribute("id", beanName);
            } else {
                builder.addAttribute("name", beanName);
            }
        }
        if (beanClassName != null) {
            builder.addAttribute("class", beanClassName);
        }
        if (isAbstract) {
            builder.addAttribute("abstract", "true");
        }
        if (isLazyInit) {
            builder.addAttribute("lazy-init", "true");
        }
        if (scope != null && !"singleton".equals(scope)) {
            builder.addAttribute("scope", scope);
        }
        if (beanDefinition instanceof AbstractBeanDefinition) {
            String dependsCheck;
            String autowire;
            String factoryMethodName;
            String factoryBeanName;
            String destroyMethod;
            AbstractBeanDefinition abstractBeanDefinition = (AbstractBeanDefinition)beanDefinition;
            String initMethod = abstractBeanDefinition.getInitMethodName();
            if (initMethod != null) {
                builder.addAttribute("init-method", initMethod);
            }
            if ((destroyMethod = abstractBeanDefinition.getDestroyMethodName()) != null) {
                builder.addAttribute("destroy-method", destroyMethod);
            }
            if ((factoryBeanName = abstractBeanDefinition.getFactoryBeanName()) != null) {
                builder.addAttribute("factory-bean", factoryBeanName);
            }
            if ((factoryMethodName = abstractBeanDefinition.getFactoryMethodName()) != null) {
                builder.addAttribute("factory-method", factoryMethodName);
            }
            int autowireMode = abstractBeanDefinition.getAutowireMode();
            int dependencyCheck = abstractBeanDefinition.getDependencyCheck();
            Object[] dependsOn = abstractBeanDefinition.getDependsOn();
            if (dependsOn != null && dependsOn.length > 0) {
                String dependsOnValue = StringUtils.arrayToCommaDelimitedString((Object[])dependsOn);
                builder.addAttribute("depends-on", dependsOnValue);
            }
            if ((autowire = this.getAutowireModeString(autowireMode)) != null && !"no".equals(autowire)) {
                builder.addAttribute("autowire", autowire);
            }
            if ((dependsCheck = this.getDependencyCheck(dependencyCheck)) != null && !"none".equals(dependsCheck)) {
                builder.addAttribute("dependency-check", dependsCheck);
            }
        }
        if (beanDefinition instanceof ChildBeanDefinition && (parent = (childBeanDefinition = (ChildBeanDefinition)beanDefinition).getParentName()) != null) {
            builder.addAttribute("parent", parent);
        }
        if ((description = this.metadataElementDescriptionCreator.getBeanDefinitionDescription(beanName, beanDefinition)) != null) {
            elementBuilder.addChild("description");
            elementBuilder.addPCData(description);
            elementBuilder.up();
        }
    }

    private boolean isBeanNameApplicableForID(String beanName) {
        return beanName.indexOf(35) != -1 && beanName.indexOf(46) != -1;
    }

    private void generateRoot(ElementBuilder builder) {
        assert (builder != null);
        builder.createRoot("beans");
    }

    private Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    private void generateLookupMethods(BeanDefinition beanDefinition, ElementBuilder builder) {
        if (beanDefinition instanceof AbstractBeanDefinition) {
            AbstractBeanDefinition def = (AbstractBeanDefinition)beanDefinition;
            MethodOverrides overrides = def.getMethodOverrides();
            Set overridesSet = overrides.getOverrides();
            for (MethodOverride override : overridesSet) {
                this.generateMethodOverride(override, builder);
            }
        }
    }

    private void generateMethodOverride(MethodOverride override, ElementBuilder builder) {
        if (override instanceof LookupOverride) {
            LookupOverride lookupOverride = (LookupOverride)override;
            builder.addChild("lookup-method");
            String methodName = lookupOverride.getMethodName();
            builder.addAttribute("name", methodName);
            String targetBeanName = lookupOverride.getBeanName();
            builder.addAttribute("bean", targetBeanName);
            builder.up();
        } else if (override instanceof ReplaceOverride) {
            ReplaceOverride replaceOverride = (ReplaceOverride)override;
            builder.addChild("replaced-method");
            String methodName = replaceOverride.getMethodName();
            String beanName = replaceOverride.getMethodReplacerBeanName();
            builder.addAttribute("name", methodName);
            builder.addAttribute("replacer", beanName);
            builder.up();
        }
    }

    private void generateConstructorArguments(BeanDefinition beanDefinition, ElementBuilder builder) {
        ConstructorArgumentValues args = beanDefinition.getConstructorArgumentValues();
        if (args != null) {
            Map indexedArguments;
            List genericArguments = args.getGenericArgumentValues();
            if (genericArguments.size() > 0) {
                for (ConstructorArgumentValues.ValueHolder holder : genericArguments) {
                    this.generateConstructorArgument(-1, holder, builder);
                }
            }
            if ((indexedArguments = args.getIndexedArgumentValues()).size() > 0) {
                for (Map.Entry entry : indexedArguments.entrySet()) {
                    Integer index = (Integer)entry.getKey();
                    ConstructorArgumentValues.ValueHolder holder = (ConstructorArgumentValues.ValueHolder)entry.getValue();
                    this.generateConstructorArgument(index, holder, builder);
                }
            }
        }
    }

    private void generateConstructorArgument(int i, ConstructorArgumentValues.ValueHolder holder, ElementBuilder builder) {
        String type;
        builder.addChild("constructor-arg");
        if (i >= 0) {
            builder.addAttribute("index", Integer.toString(i));
        }
        if ((type = holder.getType()) != null) {
            builder.addAttribute("type", type);
        }
        Object value = holder.getValue();
        this.processValue(value, builder, false, false);
        builder.up();
    }

    private void processValue(Object value, ElementBuilder builder, boolean fullFormForReference, boolean inMap) {
        if (value instanceof BeanDefinition) {
            this.processBeanDefinition(null, (BeanDefinition)value, builder, true);
        } else if (value instanceof BeanDefinitionHolder) {
            BeanDefinitionHolder holder = (BeanDefinitionHolder)value;
            this.processBeanDefinition(holder.getBeanName(), holder.getBeanDefinition(), builder, true);
        } else if (value instanceof RuntimeBeanReference) {
            this.processRuntimeBeanReference(value, builder, fullFormForReference, inMap);
        } else if (value instanceof List) {
            this.processList((List)value, builder);
        } else if (value instanceof Set) {
            this.processSet((Set)value, builder);
        } else if (value instanceof Map) {
            this.processMap((Map)value, builder);
        } else if (value instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)value;
            String stringValue = typedStringValue.getValue();
            if (fullFormForReference) {
                builder.addChild("value");
            }
            if (stringValue != null) {
                String targetTypeName = typedStringValue.getTargetTypeName();
                if (!fullFormForReference && targetTypeName != null) {
                    builder.addChild("value");
                    builder.addAttribute("type", targetTypeName);
                    builder.addPCData(stringValue);
                    builder.up();
                } else if (inMap) {
                    builder.addAttribute("value", stringValue);
                } else {
                    builder.addPCData(stringValue);
                }
            } else {
                builder.addChild("null");
                builder.up();
            }
            if (fullFormForReference) {
                builder.up();
            }
        } else if (value instanceof String) {
            if (fullFormForReference) {
                builder.addChild("value");
                builder.addPCData((String)value);
                builder.up();
            } else {
                builder.addAttribute("value", (String)value);
            }
        } else if (value == null) {
            builder.addChild("null");
            builder.up();
        } else {
            String str = value.toString();
            if (fullFormForReference) {
                builder.addChild("value");
                builder.addPCData(str);
                builder.up();
            } else {
                builder.addAttribute("value", str);
            }
        }
    }

    private void processRuntimeBeanReference(Object value, ElementBuilder builder, boolean fullFormForReference, boolean inMap) {
        RuntimeBeanReference ref = (RuntimeBeanReference)value;
        String beanName = ref.getBeanName();
        if (fullFormForReference) {
            builder.addChild("ref");
            builder.addAttribute("bean", beanName);
            builder.up();
        } else if (inMap) {
            builder.addAttribute("value-ref", beanName);
        } else {
            builder.addAttribute("ref", beanName);
        }
    }

    private void processMap(Map map, ElementBuilder builder) {
        assert (map != null);
        assert (builder != null);
        builder.addChild("map");
        for (Object key : map.keySet()) {
            String keyValue;
            Object value = map.get(key);
            builder.addChild("entry");
            if (key instanceof String) {
                keyValue = (String)key;
                builder.addAttribute("key", keyValue);
            } else if (key instanceof TypedStringValue) {
                TypedStringValue typedStringValue = (TypedStringValue)key;
                keyValue = typedStringValue.getValue();
                builder.addAttribute("key", keyValue);
            } else if (key instanceof RuntimeBeanReference) {
                RuntimeBeanReference reference = (RuntimeBeanReference)key;
                String beanName = reference.getBeanName();
                builder.addAttribute("key-ref", beanName);
            } else {
                keyValue = key.toString();
                builder.addAttribute("key", keyValue);
            }
            this.processValue(value, builder, false, true);
            builder.up();
        }
        builder.up();
    }

    private void processSet(Set set, ElementBuilder builder) {
        builder.addChild("set");
        for (Object value : set) {
            this.processValue(value, builder, true, false);
        }
        builder.up();
    }

    private void processList(List list, ElementBuilder builder) {
        builder.addChild("list");
        for (Object value : list) {
            this.processValue(value, builder, true, false);
        }
        builder.up();
    }

    private void generateBeanDefinitions(ConfigurableListableBeanFactory beanFactory, ElementBuilder builder) {
        Object[] names = beanFactory.getBeanDefinitionNames();
        if (this.sortBeansByName) {
            Arrays.sort(names);
        }
        for (Object name : names) {
            BeanDefinition definition = beanFactory.getBeanDefinition((String)name);
            this.processBeanDefinition((String)name, definition, builder, false);
        }
    }

    private void generateBeanAliases(ConfigurableListableBeanFactory beanFactory, ElementBuilder builder) {
        String[] names;
        for (String name : names = beanFactory.getBeanDefinitionNames()) {
            String[] aliases = beanFactory.getAliases(name);
            if (aliases.length <= 0) continue;
            for (String alias : aliases) {
                this.generateAlias(builder, name, alias);
            }
        }
    }

    private void generateAlias(ElementBuilder builder, String beanName, String alias) {
        builder.addChild("alias");
        builder.addAttribute("name", beanName);
        builder.addAttribute("alias", alias);
        builder.up();
    }

    private String getDependencyCheck(int dependencyCheck) {
        String result = null;
        switch (dependencyCheck) {
            case 3: {
                result = "all";
                break;
            }
            case 0: {
                result = "none";
                break;
            }
            case 2: {
                result = "simple";
                break;
            }
            case 1: {
                result = "objects";
            }
        }
        return result;
    }

    private String getAutowireModeString(int value) {
        String result = null;
        switch (value) {
            case 0: {
                result = "no";
                break;
            }
            case 1: {
                result = "byName";
                break;
            }
            case 2: {
                result = "byType";
                break;
            }
            case 3: {
                result = "constructor";
                break;
            }
            case 4: {
                result = "autodetect";
            }
        }
        return result;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private static interface MetadataElementDescriptionCreator {
        public static final MetadataElementDescriptionCreator DUMMY = new MetadataElementDescriptionCreator(){

            public String getBeanDefinitionDescription(String beanName, BeanDefinition beanDefinition) {
                return null;
            }

            public String getPropertyValueBeanDefinitionDescription(BeanDefinition beanDefinition, PropertyValue property) {
                return null;
            }
        };

        public String getBeanDefinitionDescription(String var1, BeanDefinition var2);

        public String getPropertyValueBeanDefinitionDescription(BeanDefinition var1, PropertyValue var2);
    }

    public class ElementBuilder {
        private Document document = null;
        private Element rootElement = null;
        private Stack<Element> stack = new Stack();

        public ElementBuilder(Document document) {
            this.document = document;
        }

        public ElementBuilder createRoot(String elementName) {
            this.doCreateRootElement(elementName);
            return this;
        }

        private Element doCreateRootElement(String elementName) {
            this.rootElement = this.document.createElement(elementName);
            this.document.appendChild(this.rootElement);
            this.stack.push(this.rootElement);
            return this.rootElement;
        }

        public ElementBuilder addAttribute(String attributeName, String value) {
            Element elm = this.stack.peek();
            elm.setAttribute(attributeName, value);
            return this;
        }

        public ElementBuilder addPCData(String pcData) {
            Element elm = this.stack.peek();
            CDATASection cdata = this.document.createCDATASection(pcData);
            elm.appendChild(cdata);
            return this;
        }

        public ElementBuilder addChild(String elementName) {
            this.doAddChild(elementName);
            return this;
        }

        private Element doAddChild(String elementName) {
            Element currentElement = this.stack.peek();
            Element result = this.document.createElement(elementName);
            currentElement.appendChild(result);
            this.stack.push(result);
            return result;
        }

        public Element getRoot() {
            return this.rootElement;
        }

        public ElementBuilder up() {
            this.stack.pop();
            return this;
        }

        public void clear() {
            this.rootElement = null;
            this.stack.clear();
        }

        public Element getCurrent() {
            return this.stack.peek();
        }
    }
}

