/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.vfs;

import java.util.Collections;
import java.util.List;
import jline.Completor;
import org.apache.commons.vfs.FileFilter;
import org.apache.commons.vfs.FileFilterSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.geronimo.gshell.vfs.FileObjects;
import org.apache.geronimo.gshell.vfs.FileSystemAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileObjectNameCompleter
implements Completor {
    private static final String PARENT_TOKEN = "..";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FileSystemAccess fileSystemAccess;

    public FileObjectNameCompleter(FileSystemAccess fileSystemAccess) {
        assert (fileSystemAccess != null);
        this.fileSystemAccess = fileSystemAccess;
    }

    public int complete(String buffer, int cursor, List candidates) {
        assert (candidates != null);
        String path = buffer == null ? "" : buffer;
        this.log.trace("Path: '{}'", (Object)path);
        try {
            String search;
            FileObject file = this.fileSystemAccess.resolveFile(path);
            this.log.trace("Resolved file: {}", (Object)file);
            if (!file.exists() || file.getType() == FileType.FILE) {
                search = file.getName().getBaseName();
                if (!path.endsWith("/")) {
                    file = file.getParent();
                }
            } else {
                if (file.getType().hasChildren() && !path.endsWith("/")) {
                    StringBuilder buff = new StringBuilder();
                    if (path.endsWith(PARENT_TOKEN)) {
                        buff.append(PARENT_TOKEN);
                    } else {
                        buff.append(file.getName().getBaseName());
                    }
                    buff.append("/");
                    candidates.add(buff.toString());
                    int result = path.lastIndexOf("/") + 1;
                    this.log.trace("Result: {}", (Object)result);
                    FileObjects.close(file);
                    return result;
                }
                search = null;
            }
            this.log.trace("Base File: {}", (Object)file);
            this.log.trace("Search: {}", (Object)search);
            if (file != null) {
                FileObject[] files;
                if (search != null) {
                    FileFilter filter = new FileFilter(){

                        public boolean accept(FileSelectInfo selection) {
                            assert (selection != null);
                            if (FileObjectNameCompleter.this.log.isTraceEnabled()) {
                                FileObjectNameCompleter.this.log.trace("Filtering selection: {}", (Object)selection.getFile().getName());
                            }
                            return selection.getFile().getName().getBaseName().startsWith(search);
                        }
                    };
                    files = file.findFiles((FileSelector)new FileFilterSelector(filter));
                } else {
                    files = file.getChildren();
                }
                if (files == null || files.length == 0) {
                    this.log.trace("No matching files found");
                } else {
                    this.log.trace("Found {} matching files:", (Object)files.length);
                    for (FileObject child : files) {
                        this.log.trace("    {}", (Object)child);
                        StringBuilder buff = new StringBuilder();
                        buff.append(child.getName().getBaseName());
                        if (files.length == 1 && child.getType().hasChildren()) {
                            buff.append("/");
                        } else {
                            buff.append(" ");
                        }
                        candidates.add(buff.toString());
                    }
                    Collections.sort(candidates);
                    FileObjects.closeAll(files);
                }
            }
            int result = search == null ? path.length() : path.lastIndexOf("/") + 1;
            this.log.trace("Result: {}", (Object)result);
            FileObjects.close(file);
            return result;
        }
        catch (FileSystemException e) {
            this.log.trace("Unable to complete path: " + path, (Throwable)e);
            return -1;
        }
    }
}

