/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.vfs;

import java.io.File;
import java.lang.reflect.Field;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.provider.DelegateFileObject;
import org.apache.commons.vfs.provider.local.LocalFile;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.shell.ShellContextHolder;
import org.apache.geronimo.gshell.vfs.FileSystemAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemAccessImpl
implements FileSystemAccess {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FileSystemManager fileSystemManager;

    public FileSystemAccessImpl(FileSystemManager fileSystemManager) {
        assert (fileSystemManager != null);
        this.fileSystemManager = fileSystemManager;
    }

    public FileSystemManager getManager() {
        return this.fileSystemManager;
    }

    public FileObject getCurrentDirectory(Variables vars) throws FileSystemException {
        assert (vars != null);
        FileObject cwd = null;
        Object var = vars.get("vfs.cwd");
        if (var instanceof String) {
            this.log.trace("Resolving CWD from string: {}", var);
            cwd = this.getManager().resolveFile((String)var);
        } else if (var instanceof FileObject) {
            cwd = (FileObject)var;
        } else if (var != null) {
            throw new RuntimeException("Invalid variable type for 'vfs.cwd'; expected String or FileObject; found: " + var.getClass());
        }
        if (cwd == null) {
            this.log.trace("CWD not set, resolving from user.dir");
            String userDir = "file://" + System.getProperty("user.dir");
            cwd = this.getManager().resolveFile(userDir);
        }
        return cwd;
    }

    public FileObject getCurrentDirectory() throws FileSystemException {
        this.log.trace("Resolving CWD from application variables");
        return this.getCurrentDirectory(ShellContextHolder.get().getVariables());
    }

    public void setCurrentDirectory(Variables vars, FileObject dir) throws FileSystemException {
        assert (vars != null);
        assert (dir != null);
        this.log.trace("Setting CWD: {}", (Object)dir);
        if (!dir.exists()) {
            throw new RuntimeException("Directory not found: " + dir.getName());
        }
        if (!dir.getType().hasChildren()) {
            throw new RuntimeException("File can not contain children: " + dir.getName());
        }
        vars.parent().set("vfs.cwd", dir);
    }

    public void setCurrentDirectory(FileObject dir) throws FileSystemException {
        assert (dir != null);
        this.log.trace("Setting CWD to application variables");
        this.setCurrentDirectory(ShellContextHolder.get().getVariables(), dir);
    }

    public FileObject resolveFile(FileObject baseFile, String name) throws FileSystemException {
        FileObject f = this.getManager().resolveFile(baseFile, name);
        FileObject d = this.dereference(f);
        if (d != null) {
            d.refresh();
        }
        return f;
    }

    public FileObject resolveFile(String name) throws FileSystemException {
        FileObject f = this.getManager().resolveFile(this.getCurrentDirectory(), name);
        FileObject d = this.dereference(f);
        if (d != null) {
            d.refresh();
        }
        return f;
    }

    public boolean isLocalFile(FileObject file) {
        return file instanceof LocalFile;
    }

    public File getLocalFile(FileObject file) throws FileSystemException {
        if (!this.isLocalFile(file)) {
            throw new FileSystemException("Unable to get local file from: " + file.getClass());
        }
        try {
            file.refresh();
            Field field = LocalFile.class.getDeclaredField("file");
            try {
                return (File)field.get(file);
            }
            catch (IllegalAccessException ignore) {
                field.setAccessible(true);
                return (File)field.get(file);
            }
        }
        catch (Exception e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public FileObject dereference(FileObject file) throws FileSystemException {
        assert (file != null);
        if (file instanceof DelegateFileObject) {
            try {
                file.refresh();
                Field field = DelegateFileObject.class.getDeclaredField("file");
                try {
                    return (FileObject)field.get(file);
                }
                catch (IllegalAccessException ignore) {
                    field.setAccessible(true);
                    return (FileObject)field.get(file);
                }
            }
            catch (Exception e) {
                throw new FileSystemException((Throwable)e);
            }
        }
        return file;
    }

    public FileObject createVirtualFileSystem(String rootUri) throws FileSystemException {
        assert (rootUri != null);
        FileObject file = this.getManager().resolveFile(rootUri);
        return this.getManager().createVirtualFileSystem(file);
    }

    public FileObject createVirtualFileSystem(FileObject rootFile) throws FileSystemException {
        assert (rootFile != null);
        return this.getManager().createVirtualFileSystem(rootFile);
    }
}

