/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.vfs.provider.meta;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileNameParser;
import org.apache.commons.vfs.provider.FileNameParser;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponentContext;
import org.apache.geronimo.gshell.vfs.provider.meta.MetaFileName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaFileNameParser
extends AbstractFileNameParser {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String defaultScheme;

    public MetaFileNameParser(String scheme) {
        assert (scheme != null);
        this.defaultScheme = scheme;
    }

    public MetaFileNameParser() {
        this("meta");
    }

    public FileName parseUri(FileName baseName, String fileName) throws FileSystemException {
        assert (fileName != null);
        this.log.trace("Parsing URI; base={}, filename={}", (Object)baseName, (Object)fileName);
        StringBuffer buff = new StringBuffer();
        String scheme = UriParser.extractScheme((String)fileName, (StringBuffer)buff);
        if (scheme == null) {
            scheme = this.defaultScheme;
        }
        UriParser.canonicalizePath((StringBuffer)buff, (int)0, (int)buff.length(), (FileNameParser)this);
        UriParser.fixSeparators((StringBuffer)buff);
        FileType type = UriParser.normalisePath((StringBuffer)buff);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Creating file name; scheme={}, path={}, type={}", new Object[]{scheme, buff, type});
        }
        MetaFileName name = new MetaFileName(scheme, buff.toString(), type);
        this.log.trace("Created file name: {}", (Object)name);
        return name;
    }

    public FileName parseUri(VfsComponentContext context, FileName baseName, String fileName) throws FileSystemException {
        return this.parseUri(baseName, fileName);
    }

    public FileName parseUri(String fileName) throws FileSystemException {
        return this.parseUri(null, fileName);
    }
}

