/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.vfs.provider.meta;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs.provider.FileNameParser;
import org.apache.geronimo.gshell.vfs.provider.meta.MetaFileNameParser;
import org.apache.geronimo.gshell.vfs.provider.meta.MetaFileSystem;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaDataRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaFileProvider
extends AbstractOriginatingFileProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final Collection<Capability> CAPABILITIES = Collections.unmodifiableCollection(Arrays.asList(Capability.ATTRIBUTES, Capability.READ_CONTENT, Capability.GET_TYPE, Capability.GET_LAST_MODIFIED, Capability.LAST_MODIFIED, Capability.LIST_CHILDREN, Capability.URI));
    private final MetaDataRegistry registry;

    public MetaFileProvider(MetaDataRegistry registry) {
        assert (registry != null);
        this.registry = registry;
        this.setFileNameParser((FileNameParser)new MetaFileNameParser());
    }

    public Collection getCapabilities() {
        return CAPABILITIES;
    }

    protected FileSystem doCreateFileSystem(FileName fileName, FileSystemOptions options) throws FileSystemException {
        assert (this.registry != null);
        MetaFileSystem fileSystem = new MetaFileSystem(this.registry, fileName, options);
        this.log.debug("Created file system: {}", (Object)fileSystem);
        return fileSystem;
    }
}

