/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.vfs.provider.meta.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileType;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaDataContent;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaDataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaData {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FileName name;
    private final FileType type;
    private final MetaDataContent content;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Collection<MetaData> children = new ArrayList<MetaData>();
    private long lastModified = -1L;

    public MetaData(FileName name, FileType type, MetaDataContent content) {
        assert (name != null);
        assert (type != null);
        this.name = name;
        this.type = type;
        this.content = content;
    }

    public MetaData(FileName name, FileType type) {
        this(name, type, null);
    }

    public MetaData(FileName name, MetaDataContent content) {
        this(name, FileType.FILE_OR_FOLDER, content);
    }

    public MetaData(FileName name) {
        this(name, FileType.FILE_OR_FOLDER, null);
    }

    public FileName getName() {
        return this.name;
    }

    public FileType getType() {
        return this.type;
    }

    public byte[] getBuffer() {
        return this.content != null ? this.content.getBuffer() : null;
    }

    public void updateLastModified() {
        this.lastModified = System.currentTimeMillis();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getContentType() {
        return this.content != null ? this.content.getType() : null;
    }

    public String getContentEncoding() {
        return this.content != null ? this.content.getEncoding() : null;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String name, Object value) {
        assert (name != null);
        this.getAttributes().put(name, value);
        this.updateLastModified();
    }

    public Object removeAttribute(String name) {
        assert (name != null);
        Object old = this.getAttributes().remove(name);
        this.updateLastModified();
        return old;
    }

    public Collection<MetaData> getChildren() {
        return this.children;
    }

    public void addChild(MetaData data) {
        assert (data != null);
        if (!this.getType().hasChildren()) {
            throw new MetaDataException("A child can only be added in a folder");
        }
        if (this.hasChild(data)) {
            throw new MetaDataException("Child already exists: " + data);
        }
        this.log.trace("Adding child: {}", (Object)data);
        this.getChildren().add(data);
        this.updateLastModified();
    }

    public void removeChild(MetaData data) {
        assert (data != null);
        if (!this.getType().hasChildren()) {
            throw new MetaDataException("A child can only be removed from a folder");
        }
        if (!this.hasChild(data)) {
            throw new MetaDataException("Child not found: " + data);
        }
        this.log.trace("Removing child: {}", (Object)data);
        this.getChildren().remove(data);
        this.updateLastModified();
    }

    public boolean hasChild(MetaData data) {
        assert (data != null);
        return this.getChildren().contains(data);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MetaData that = (MetaData)obj;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName().toString();
    }
}

