/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.application;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.geronimo.gshell.application.Application;
import org.apache.geronimo.gshell.application.ApplicationConfiguration;
import org.apache.geronimo.gshell.application.ClassPath;
import org.apache.geronimo.gshell.application.model.ApplicationModel;
import org.apache.geronimo.gshell.artifact.Artifact;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.io.IO;

public class ApplicationImpl
implements Application {
    private final ApplicationConfiguration config;
    private ClassPath classPath;
    private InetAddress localHost;
    private File homeDir;

    public ApplicationImpl(ApplicationConfiguration config) throws Exception {
        assert (config != null);
        this.config = config;
        this.homeDir = this.detectHomeDir();
        this.localHost = InetAddress.getLocalHost();
    }

    public String getId() {
        return this.config.getModel().getId();
    }

    public Artifact getArtifact() {
        return this.config.getModel().getArtifact();
    }

    public IO getIo() {
        return this.config.getIo();
    }

    public Variables getVariables() {
        return this.config.getVariables();
    }

    public ClassPath getClassPath() {
        if (this.classPath == null) {
            throw new IllegalStateException("Classpath not initialized");
        }
        return this.classPath;
    }

    void initClassPath(ClassPath classPath) {
        assert (classPath != null);
        this.classPath = classPath;
    }

    public ApplicationModel getModel() {
        return this.config.getModel();
    }

    public File getHomeDir() {
        if (this.homeDir == null) {
            throw new IllegalStateException();
        }
        return this.homeDir;
    }

    public InetAddress getLocalHost() {
        if (this.localHost == null) {
            throw new IllegalStateException();
        }
        return this.localHost;
    }

    public String getUserName() {
        return System.getProperty("user.name");
    }

    private File detectHomeDir() {
        File dir;
        String homePath = System.getProperty("user.home");
        try {
            dir = new File(homePath).getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to resolve home directory: " + homePath, e);
        }
        if (!dir.exists() || !dir.isDirectory()) {
            throw new RuntimeException("Home directory configured but is not a valid directory: " + dir);
        }
        return dir;
    }
}

