/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.application;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Collection;
import org.apache.geronimo.gshell.application.Application;
import org.apache.geronimo.gshell.application.ApplicationConfiguration;
import org.apache.geronimo.gshell.application.ApplicationManager;
import org.apache.geronimo.gshell.application.ClassPath;
import org.apache.geronimo.gshell.application.model.ApplicationModel;
import org.apache.geronimo.gshell.artifact.Artifact;
import org.apache.geronimo.gshell.artifact.ArtifactResolver;
import org.apache.geronimo.gshell.chronos.StopWatch;
import org.apache.geronimo.gshell.event.EventPublisher;
import org.apache.geronimo.gshell.shell.Shell;
import org.apache.geronimo.gshell.shell.ShellContext;
import org.apache.geronimo.gshell.shell.ShellContextHolder;
import org.apache.geronimo.gshell.spring.BeanContainer;
import org.apache.geronimo.gshell.spring.BeanContainerAware;
import org.apache.geronimo.gshell.wisdom.application.ApplicationArtifactFilter;
import org.apache.geronimo.gshell.wisdom.application.ApplicationConfiguredEvent;
import org.apache.geronimo.gshell.wisdom.application.ApplicationImpl;
import org.apache.geronimo.gshell.wisdom.application.ClassPathCache;
import org.apache.geronimo.gshell.wisdom.application.ClassPathImpl;
import org.apache.geronimo.gshell.wisdom.application.ShellCreatedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationManagerImpl
implements ApplicationManager,
BeanContainerAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EventPublisher eventPublisher;
    private ArtifactResolver artifactResolver;
    private BeanContainer container;
    private BeanContainer applicationContainer;
    private Application application;

    public ApplicationManagerImpl(EventPublisher eventPublisher, ArtifactResolver artifactResolver) {
        assert (eventPublisher != null);
        this.eventPublisher = eventPublisher;
        assert (artifactResolver != null);
        this.artifactResolver = artifactResolver;
    }

    @Override
    public void setBeanContainer(BeanContainer container) {
        assert (container != null);
        this.container = container;
    }

    @Override
    public Application getApplication() {
        if (this.application == null) {
            throw new IllegalStateException("Application has not been configured");
        }
        return this.application;
    }

    @Override
    public void configure(ApplicationConfiguration config) throws Exception {
        assert (config != null);
        this.log.trace("Configuring; config: {}", (Object)config);
        config.validate();
        this.application = this.loadApplication(config);
        this.log.debug("Application configured");
        this.eventPublisher.publish(new ApplicationConfiguredEvent(this.application));
    }

    private ApplicationImpl loadApplication(ApplicationConfiguration config) throws Exception {
        assert (config != null);
        StopWatch watch = new StopWatch(true);
        ApplicationImpl app = new ApplicationImpl(config);
        ApplicationModel model = app.getModel();
        this.log.debug("Loading application: {}", (Object)app.getId());
        this.log.trace("Application model: {}", (Object)model);
        ClassPath classPath = this.loadClassPath(model);
        app.initClassPath(classPath);
        BeanContainer child = this.container.createChild(classPath.getUrls());
        this.log.debug("Application container: {}", (Object)child);
        child.loadBeans(new String[]{"classpath*:META-INF/gshell/components.xml"});
        this.applicationContainer = child;
        this.log.debug("Application loaded in: {}", (Object)watch);
        return app;
    }

    private ClassPath loadClassPath(ApplicationModel model) throws Exception {
        assert (model != null);
        Artifact artifact = model.getArtifact();
        ClassPathCache cache = new ClassPathCache(new File(new File(System.getProperty("gshell.home")), "var/" + artifact.getGroup() + "/" + artifact.getName() + "/classpath.ser"));
        ClassPath classPath = cache.get();
        if (classPath == null) {
            Collection<Artifact> artifacts = this.resolveArtifacts(model);
            classPath = new ClassPathImpl(artifacts);
            cache.set(classPath);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Application classpath:");
            for (URL url : classPath.getUrls()) {
                this.log.debug("    {}", (Object)url);
            }
        }
        return classPath;
    }

    private Collection<Artifact> resolveArtifacts(ApplicationModel model) throws Exception {
        assert (model != null);
        this.log.debug("Resolving application artifacts");
        ArtifactResolver.Request request = new ArtifactResolver.Request();
        request.filter = new ApplicationArtifactFilter();
        request.artifact = model.getArtifact();
        request.artifacts = model.getDependencies();
        ArtifactResolver.Result result = this.artifactResolver.resolve(request);
        return result.artifacts;
    }

    @Override
    public Shell create() throws Exception {
        this.getApplication();
        final Shell shell = this.applicationContainer.getBean(Shell.class);
        final ShellContext context = shell.getContext();
        this.log.debug("Created shell instance: {}", (Object)shell);
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                assert (proxy != null);
                assert (method != null);
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                ShellContext prevContext = ShellContextHolder.get(true);
                ShellContextHolder.set(context);
                try {
                    Object object = method.invoke((Object)shell, args);
                    return object;
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                finally {
                    ShellContextHolder.set(prevContext);
                }
            }
        };
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Shell proxy = (Shell)Proxy.newProxyInstance(cl, new Class[]{Shell.class}, handler);
        this.log.debug("Create shell proxy: {}", (Object)proxy);
        this.eventPublisher.publish(new ShellCreatedEvent(proxy));
        return proxy;
    }
}

