/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.application;

import java.security.Permission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationSecurityManager
extends SecurityManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SecurityManager parent;

    public ApplicationSecurityManager(SecurityManager parent) {
        this.parent = parent;
    }

    public ApplicationSecurityManager() {
        this(System.getSecurityManager());
    }

    public void checkPermission(Permission perm) {
        assert (perm != null);
        this.log.trace("Checking permission of: {}", (Object)perm);
        if (perm instanceof RuntimePermission && perm.implies(new RuntimePermission("exitVM"))) {
            throw new SecurityException();
        }
        if (this.parent != null) {
            this.parent.checkPermission(perm);
        }
    }
}

