/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.application;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.geronimo.gshell.application.ClassPath;
import org.apache.geronimo.gshell.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathImpl
implements ClassPath,
Serializable {
    private static final long serialVersionUID = 1L;
    private Collection<Artifact> artifacts;
    private transient Collection<URL> urls;

    public ClassPathImpl() {
    }

    public ClassPathImpl(Collection<Artifact> artifacts) {
        assert (artifacts != null);
        this.artifacts = artifacts;
    }

    @Override
    public Collection<Artifact> getArtifacts() {
        assert (this.artifacts != null);
        return Collections.unmodifiableCollection(this.artifacts);
    }

    @Override
    public Collection<URL> getUrls() {
        if (this.urls == null) {
            ArrayList<URL> list = new ArrayList<URL>(this.artifacts.size());
            try {
                for (Artifact artifact : this.artifacts) {
                    File file = artifact.getFile();
                    if (file == null) {
                        throw new RuntimeException("Artifact missing file reference: " + artifact);
                    }
                    list.add(file.toURI().toURL());
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            this.urls = Collections.unmodifiableCollection(list);
        }
        return this.urls;
    }

    @Override
    public boolean isValid() {
        for (Artifact artifact : this.artifacts) {
            File file = artifact.getFile();
            if (file == null || file.exists()) continue;
            return false;
        }
        return true;
    }
}

