/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.builder;

import org.apache.geronimo.gshell.application.ApplicationConfiguration;
import org.apache.geronimo.gshell.application.ApplicationManager;
import org.apache.geronimo.gshell.application.model.ApplicationModel;
import org.apache.geronimo.gshell.chronos.StopWatch;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.io.SystemOutputHijacker;
import org.apache.geronimo.gshell.shell.Shell;
import org.apache.geronimo.gshell.spring.BeanContainer;
import org.apache.geronimo.gshell.spring.BeanContainerImpl;
import org.apache.geronimo.gshell.wisdom.builder.ShellBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellBuilderImpl
implements ShellBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private BeanContainer container;
    private ClassLoader classLoader;
    private ApplicationManager applicationManager;
    private ApplicationConfiguration applicationConfig = new ApplicationConfiguration();

    private BeanContainer createContainer() throws Exception {
        BeanContainerImpl container = new BeanContainerImpl(this.getClassLoader());
        container.loadBeans(new String[]{"classpath*:META-INF/gshell/components.xml", "classpath:application.xml"});
        return container;
    }

    public BeanContainer getContainer() {
        if (this.container == null) {
            try {
                this.container = this.createContainer();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create container", e);
            }
        }
        return this.container;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public IO getIo() {
        return this.applicationConfig.getIo();
    }

    public void setIo(IO io) {
        this.applicationConfig.setIo(io);
    }

    public Variables getVariables() {
        return this.applicationConfig.getVariables();
    }

    public void setVariables(Variables variables) {
        this.applicationConfig.setVariables(variables);
    }

    private ApplicationManager createApplicationManager() {
        return this.getContainer().getBean(ApplicationManager.class);
    }

    public ApplicationManager getApplicationManager() {
        if (this.applicationManager == null) {
            this.applicationManager = this.createApplicationManager();
        }
        return this.applicationManager;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public ApplicationModel getApplicationModel() {
        return this.getContainer().getBean(ApplicationModel.class);
    }

    public Shell create() throws Exception {
        this.log.debug("Building");
        StopWatch watch = new StopWatch(true);
        if (this.applicationConfig.getIo() == null) {
            this.applicationConfig.setIo(new IO());
        }
        if (this.applicationConfig.getVariables() == null) {
            this.applicationConfig.setVariables(new Variables());
        }
        if (!SystemOutputHijacker.isInstalled()) {
            SystemOutputHijacker.install();
        }
        IO io = this.getIo();
        SystemOutputHijacker.register(io.outputStream, io.errorStream);
        BeanContainer container = this.getContainer();
        this.log.debug("Container: {}", (Object)container);
        this.applicationConfig.setModel(this.getApplicationModel());
        this.getApplicationManager().configure(this.applicationConfig);
        Shell shell = this.getApplicationManager().create();
        this.log.debug("Created shell in {}", (Object)watch);
        return shell;
    }
}

