/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.command;

import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.i18n.MessageSource;
import org.apache.geronimo.gshell.i18n.ResourceBundleMessageSource;
import org.apache.geronimo.gshell.wisdom.command.CommandSupport;
import org.apache.geronimo.gshell.wisdom.command.HelpSupport;
import org.apache.geronimo.gshell.wisdom.command.MessageSourceCommandDocumenter;
import org.apache.geronimo.gshell.wisdom.registry.CommandLocationImpl;

public class GroupCommand
extends CommandSupport {
    private String path;

    public GroupCommand() {
        this.setAction(new GroupCommandAction());
        this.setDocumenter(new GroupCommandDocumenter());
        this.setMessages(new GroupCommandMessageSource());
    }

    public String getPath() {
        if (this.path == null) {
            throw new IllegalStateException("Missing property: path");
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        if (path != null) {
            this.setLocation(new CommandLocationImpl(path));
        }
    }

    private class GroupCommandMessageSource
    implements MessageSource {
        private final MessageSource messages = new ResourceBundleMessageSource(new Class[]{GroupCommand.class, HelpSupport.class});

        private GroupCommandMessageSource() {
        }

        public String getMessage(String code) {
            return this.messages.getMessage(code);
        }

        public String format(String code, Object ... args) {
            return this.messages.format(code, args);
        }
    }

    private class GroupCommandDocumenter
    extends MessageSourceCommandDocumenter {
        private GroupCommandDocumenter() {
        }

        public String getDescription() {
            return this.getMessages().format("command.description", GroupCommand.this.getPath());
        }
    }

    private class GroupCommandAction
    implements CommandAction {
        private GroupCommandAction() {
        }

        public Object execute(CommandContext context) throws Exception {
            assert (context != null);
            String path = GroupCommand.this.getPath();
            GroupCommand.this.log.debug("Changing to group: {}", (Object)path);
            context.getVariables().parent().set("gshell.group", path);
            return CommandAction.Result.SUCCESS;
        }
    }
}

