/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.command;

import java.io.PrintWriter;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandCompleter;
import org.apache.geronimo.gshell.command.CommandDocumenter;
import org.apache.geronimo.gshell.command.CommandResult;
import org.apache.geronimo.gshell.i18n.MessageSource;
import org.apache.geronimo.gshell.registry.CommandRegistry;
import org.apache.geronimo.gshell.registry.NoSuchCommandException;
import org.apache.geronimo.gshell.shell.ShellContext;
import org.apache.geronimo.gshell.wisdom.command.CommandSupport;

public class LinkCommand
extends CommandSupport {
    private final CommandRegistry commandRegistry;
    private String target;
    private Command command;

    public LinkCommand(CommandRegistry commandRegistry, String target) {
        assert (commandRegistry != null);
        this.commandRegistry = commandRegistry;
        assert (target != null);
        this.target = target;
    }

    private Command getCommand() {
        if (this.command == null) {
            assert (this.commandRegistry != null);
            assert (this.target != null);
            try {
                this.command = this.commandRegistry.getCommand(this.target);
            }
            catch (NoSuchCommandException e) {
                throw new RuntimeException("Link target command not found: " + this.target, e);
            }
        }
        return this.command;
    }

    public CommandResult execute(ShellContext context, Object[] args) {
        return this.getCommand().execute(context, args);
    }

    public CommandAction getAction() {
        return this.getCommand().getAction();
    }

    public CommandDocumenter getDocumenter() {
        final CommandDocumenter delegate = this.getCommand().getDocumenter();
        return new CommandDocumenter(){

            public String getDescription() {
                return "Link to: " + LinkCommand.this.target;
            }

            public void renderUsage(PrintWriter out) {
                delegate.renderUsage(out);
            }

            public void renderManual(PrintWriter out) {
                delegate.renderManual(out);
            }
        };
    }

    public CommandCompleter getCompleter() {
        return this.getCommand().getCompleter();
    }

    public MessageSource getMessages() {
        return this.getCommand().getMessages();
    }
}

