/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.completer;

import java.util.Collection;
import java.util.List;
import jline.Completor;
import org.apache.geronimo.gshell.console.completer.StringsCompleter;
import org.apache.geronimo.gshell.event.Event;
import org.apache.geronimo.gshell.event.EventListener;
import org.apache.geronimo.gshell.event.EventManager;
import org.apache.geronimo.gshell.registry.AliasRegistry;
import org.apache.geronimo.gshell.wisdom.registry.AliasRegisteredEvent;
import org.apache.geronimo.gshell.wisdom.registry.AliasRemovedEvent;

public class AliasNameCompleter
implements Completor {
    private final EventManager eventManager;
    private final AliasRegistry aliasRegistry;
    private final StringsCompleter delegate = new StringsCompleter();

    public AliasNameCompleter(EventManager eventManager, AliasRegistry aliasRegistry) {
        assert (eventManager != null);
        this.eventManager = eventManager;
        assert (aliasRegistry != null);
        this.aliasRegistry = aliasRegistry;
    }

    public void init() {
        Collection<String> names = this.aliasRegistry.getAliasNames();
        this.delegate.getStrings().addAll(names);
        this.eventManager.addListener(new EventListener(){

            public void onEvent(Event event) throws Exception {
                if (event instanceof AliasRegisteredEvent) {
                    AliasRegisteredEvent targetEvent = (AliasRegisteredEvent)event;
                    AliasNameCompleter.this.delegate.getStrings().add(targetEvent.getName());
                } else if (event instanceof AliasRemovedEvent) {
                    AliasRemovedEvent targetEvent = (AliasRemovedEvent)event;
                    AliasNameCompleter.this.delegate.getStrings().remove(targetEvent.getName());
                }
            }
        });
    }

    public int complete(String buffer, int cursor, List candidates) {
        return this.delegate.complete(buffer, cursor, candidates);
    }
}

