/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.gshell.command.Alias;
import org.apache.geronimo.gshell.command.Link;
import org.apache.geronimo.gshell.wisdom.command.AliasImpl;
import org.apache.geronimo.gshell.wisdom.command.ConfigurableCommandCompleter;
import org.apache.geronimo.gshell.wisdom.command.LinkImpl;
import org.apache.geronimo.gshell.wisdom.plugin.bundle.CommandBundle;
import org.apache.geronimo.gshell.wisdom.registry.CommandLocationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PluginParser
extends AbstractBeanDefinitionParser {
    private static final String DESCRIPTION = "description";
    private static final String PLUGIN_TEMPLATE = "pluginTemplate";
    private static final String ACTION = "action";
    private static final String ACTION_ID = "actionId";
    private static final String COMMAND_TEMPLATE_SUFFIX = "CommandTemplate";
    private static final String BUNDLE = "bundle";
    private static final String COMMAND_BUNDLE = "command-bundle";
    private static final String NAME = "name";
    private static final String LOCATION = "location";
    private static final String COMMANDS = "commands";
    private static final String COMMAND = "command";
    private static final String TYPE = "type";
    private static final String DOCUMENTER = "documenter";
    private static final String COMPLETER = "completer";
    private static final String COMPLETERS = "completers";
    private static final String BEAN = "bean";
    private static final String REF = "ref";
    private static final String NULL = "null";
    private static final String MESSAGE_SOURCE = "message-source";
    private static final String MESSAGES = "messages";
    private static final String PROTOTYPE = "prototype";
    private static final String ALIAS = "alias";
    private static final String ALIASES = "aliases";
    private static final String LINK = "link";
    private static final String LINKS = "links";
    private static final String TARGET = "target";

    protected boolean shouldGenerateId() {
        return true;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
        assert (element != null);
        assert (context != null);
        Builder builder = new Builder(context);
        BeanDefinitionBuilder plugin = builder.buildPlugin(element);
        return plugin.getBeanDefinition();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Builder {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private ParserContext context;

        public Builder(ParserContext context) {
            assert (context != null);
            this.context = context;
        }

        private String resolveId(Element element, BeanDefinition def) throws BeanDefinitionStoreException {
            assert (element != null);
            assert (def != null);
            if (PluginParser.this.shouldGenerateId()) {
                return this.context.getReaderContext().generateBeanName(def);
            }
            String id = element.getAttribute("id");
            if (!StringUtils.hasText((String)id) && PluginParser.this.shouldGenerateIdAsFallback()) {
                id = this.context.getReaderContext().generateBeanName(def);
            }
            return id;
        }

        private List<Element> getChildElements(Element element, String name) {
            assert (element != null);
            assert (name != null);
            return DomUtils.getChildElementsByTagName((Element)element, (String)name);
        }

        private List<Element> getChildElements(Element element, String[] names) {
            assert (element != null);
            assert (names != null);
            return DomUtils.getChildElementsByTagName((Element)element, (String[])names);
        }

        private Element getChildElement(Element element, String name) {
            assert (element != null);
            assert (name != null);
            List elements = DomUtils.getChildElementsByTagName((Element)element, (String)name);
            if (elements != null && !elements.isEmpty()) {
                return (Element)elements.get(0);
            }
            return null;
        }

        private BeanDefinitionParserDelegate createBeanDefinitionParserDelegate(Element element) {
            assert (element != null);
            BeanDefinitionParserDelegate parser = new BeanDefinitionParserDelegate(this.context.getReaderContext());
            parser.initDefaults(element.getOwnerDocument().getDocumentElement());
            return parser;
        }

        private BeanDefinitionHolder parseBeanDefinitionElement(Element element) {
            assert (element != null);
            BeanDefinitionParserDelegate parser = this.createBeanDefinitionParserDelegate(element);
            return parser.parseBeanDefinitionElement(element);
        }

        private void parseAndApplyDescription(Element element, BeanDefinition def) {
            assert (element != null);
            assert (def != null);
            Element desc = this.getChildElement(element, PluginParser.DESCRIPTION);
            if (desc != null && def instanceof AbstractBeanDefinition) {
                ((AbstractBeanDefinition)def).setDescription(desc.getTextContent());
            }
        }

        private void parseAndApplyDescription(Element element, BeanDefinitionBuilder builder) {
            assert (element != null);
            assert (builder != null);
            this.parseAndApplyDescription(element, (BeanDefinition)builder.getRawBeanDefinition());
        }

        private BeanDefinitionHolder register(BeanDefinitionHolder holder) {
            assert (holder != null);
            PluginParser.this.registerBeanDefinition(holder, this.context.getRegistry());
            return holder;
        }

        private BeanDefinitionHolder register(BeanDefinition def, String id) {
            assert (def != null);
            assert (id != null);
            BeanDefinitionHolder holder = new BeanDefinitionHolder(def, id);
            return this.register(holder);
        }

        public BeanDefinitionBuilder buildPlugin(Element element) {
            assert (element != null);
            BeanDefinitionBuilder plugin = this.parsePlugin(element);
            ManagedMap bundleIdMap = new ManagedMap();
            Map<String, BeanDefinitionHolder> bundles = this.parseBundles(element);
            for (Map.Entry<String, BeanDefinitionHolder> entry : bundles.entrySet()) {
                bundleIdMap.put((Object)entry.getKey(), (Object)entry.getValue().getBeanName());
            }
            bundles = this.parseCommandBundles(element);
            for (Map.Entry<String, BeanDefinitionHolder> entry : bundles.entrySet()) {
                bundleIdMap.put((Object)entry.getKey(), (Object)entry.getValue().getBeanName());
            }
            plugin.addPropertyValue("bundleIdMap", (Object)bundleIdMap);
            return plugin;
        }

        private BeanDefinitionBuilder parsePlugin(Element element) {
            assert (element != null);
            this.log.trace("Parse plugin; element: {}", (Object)element);
            BeanDefinitionBuilder plugin = BeanDefinitionBuilder.childBeanDefinition((String)PluginParser.PLUGIN_TEMPLATE);
            String name = element.getAttribute(PluginParser.NAME);
            plugin.addConstructorArgValue((Object)name);
            this.parseAndApplyDescription(element, plugin);
            return plugin;
        }

        private Map<String, BeanDefinitionHolder> parseBundles(Element element) {
            assert (element != null);
            this.log.trace("Parse bundles; element: {}", (Object)element);
            LinkedHashMap<String, BeanDefinitionHolder> bundles = new LinkedHashMap<String, BeanDefinitionHolder>();
            List<Element> children = this.getChildElements(element, PluginParser.BUNDLE);
            for (Element child : children) {
                String name = child.getAttribute(PluginParser.NAME);
                BeanDefinitionHolder holder = this.parseBeanDefinitionElement(child);
                holder.getBeanDefinition().getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)name);
                BeanDefinition def = holder.getBeanDefinition();
                String id = this.resolveId(child, def);
                holder = this.register(def, id);
                bundles.put(name, holder);
            }
            return bundles;
        }

        private Map<String, BeanDefinitionHolder> parseCommandBundles(Element element) {
            assert (element != null);
            this.log.trace("Parse command bundles; element: {}", (Object)element);
            LinkedHashMap<String, BeanDefinitionHolder> bundles = new LinkedHashMap<String, BeanDefinitionHolder>();
            List<Element> children = this.getChildElements(element, PluginParser.COMMAND_BUNDLE);
            for (Element child : children) {
                String name = child.getAttribute(PluginParser.NAME);
                BeanDefinitionBuilder bundle = this.parseCommandBundle(child);
                AbstractBeanDefinition def = bundle.getBeanDefinition();
                String id = this.resolveId(child, (BeanDefinition)def);
                BeanDefinitionHolder holder = this.register((BeanDefinition)def, id);
                bundles.put(name, holder);
            }
            return bundles;
        }

        private BeanDefinitionBuilder parseCommandBundle(Element element) {
            assert (element != null);
            this.log.trace("Parse command bundle; element; {}", (Object)element);
            BeanDefinitionBuilder bundle = BeanDefinitionBuilder.rootBeanDefinition(CommandBundle.class);
            bundle.addConstructorArgReference("commandRegistry");
            bundle.addConstructorArgReference("aliasRegistry");
            bundle.addConstructorArgValue((Object)element.getAttribute(PluginParser.NAME));
            bundle.setLazyInit(true);
            this.parseAndApplyDescription(element, bundle);
            ManagedList commands = new ManagedList();
            commands.addAll(this.parseCommands(element));
            bundle.addPropertyValue(PluginParser.COMMANDS, (Object)commands);
            ManagedList links = new ManagedList();
            links.addAll(this.parseLinks(element));
            bundle.addPropertyValue(PluginParser.LINKS, (Object)links);
            ManagedList aliases = new ManagedList();
            aliases.addAll(this.parseAliases(element));
            bundle.addPropertyValue(PluginParser.ALIASES, (Object)aliases);
            return bundle;
        }

        private List<BeanDefinition> parseCommands(Element element) {
            assert (element != null);
            this.log.trace("Parse commands; element; {}", (Object)element);
            ArrayList<BeanDefinition> commands = new ArrayList<BeanDefinition>();
            List<Element> children = this.getChildElements(element, PluginParser.COMMAND);
            for (Element child : children) {
                BeanDefinitionBuilder command = this.parseCommand(child);
                commands.add((BeanDefinition)command.getBeanDefinition());
            }
            return commands;
        }

        private CommandType parseCommandType(Element element) {
            assert (element != null);
            Attr attr = element.getAttributeNode(PluginParser.TYPE);
            if (attr == null) {
                return CommandType.STATEFUL;
            }
            return CommandType.parse(attr.getValue());
        }

        private BeanDefinitionBuilder parseCommand(Element element) {
            BeanDefinitionHolder holder;
            assert (element != null);
            this.log.trace("Parse command; element; {}", (Object)element);
            CommandType type = this.parseCommandType(element);
            BeanDefinitionBuilder command = BeanDefinitionBuilder.childBeanDefinition((String)type.getTemplateName());
            this.parseAndApplyDescription(element, command);
            String name = element.getAttribute(PluginParser.NAME);
            GenericBeanDefinition def = new GenericBeanDefinition();
            def.setBeanClassName(CommandLocationImpl.class.getName());
            def.getConstructorArgumentValues().addGenericArgumentValue((Object)name);
            command.addPropertyValue(PluginParser.LOCATION, (Object)def);
            Element child = this.getChildElement(element, PluginParser.ACTION);
            BeanDefinitionHolder action = this.parseCommandAction(child);
            type.wire(command, action);
            child = this.getChildElement(element, PluginParser.DOCUMENTER);
            if (child != null) {
                holder = this.parseBeanDefinitionElement(child);
                command.addPropertyValue(PluginParser.DOCUMENTER, (Object)holder.getBeanDefinition());
            }
            if ((child = this.getChildElement(element, PluginParser.COMPLETER)) != null) {
                holder = this.parseBeanDefinitionElement(child);
                command.addPropertyValue(PluginParser.COMPLETER, (Object)holder.getBeanDefinition());
            }
            if ((child = this.getChildElement(element, PluginParser.COMPLETERS)) != null) {
                BeanDefinitionBuilder completer = this.parseCommandCompleters(child);
                command.addPropertyValue(PluginParser.COMPLETER, (Object)completer.getBeanDefinition());
            }
            if ((child = this.getChildElement(element, PluginParser.MESSAGE_SOURCE)) != null) {
                holder = this.parseBeanDefinitionElement(child);
                command.addPropertyValue(PluginParser.MESSAGES, (Object)holder.getBeanDefinition());
            }
            return command;
        }

        private BeanDefinitionBuilder parseCommandCompleters(Element element) {
            assert (element != null);
            BeanDefinitionBuilder completer = BeanDefinitionBuilder.rootBeanDefinition(ConfigurableCommandCompleter.class);
            ManagedList completers = new ManagedList();
            List<Element> children = this.getChildElements(element, new String[]{PluginParser.BEAN, PluginParser.REF, PluginParser.NULL});
            for (Element child : children) {
                if (DomUtils.nodeNameEquals((Node)child, (String)PluginParser.BEAN)) {
                    BeanDefinitionHolder holder = this.parseBeanDefinitionElement(child);
                    completers.add((Object)holder.getBeanDefinition());
                    continue;
                }
                if (DomUtils.nodeNameEquals((Node)child, (String)PluginParser.REF)) {
                    BeanDefinitionParserDelegate parser = this.createBeanDefinitionParserDelegate(child);
                    RuntimeBeanReference ref = (RuntimeBeanReference)parser.parsePropertySubElement(child, (BeanDefinition)completer.getRawBeanDefinition());
                    completers.add((Object)ref);
                    continue;
                }
                if (!DomUtils.nodeNameEquals((Node)child, (String)PluginParser.NULL)) continue;
                completers.add(null);
            }
            completer.addConstructorArgValue((Object)completers);
            return completer;
        }

        private BeanDefinitionHolder parseCommandAction(Element element) {
            assert (element != null);
            this.log.trace("Parse command action; element; {}", (Object)element);
            BeanDefinition action = this.parseBeanDefinitionElement(element).getBeanDefinition();
            action.setScope(PluginParser.PROTOTYPE);
            String id = this.resolveId(element, action);
            return this.register(action, id);
        }

        private List<Link> parseLinks(Element element) {
            assert (element != null);
            this.log.trace("Parse links; element; {}", (Object)element);
            ArrayList<Link> links = new ArrayList<Link>();
            List<Element> children = this.getChildElements(element, PluginParser.LINK);
            for (Element child : children) {
                String name = child.getAttribute(PluginParser.NAME);
                String target = child.getAttribute(PluginParser.TARGET);
                links.add(new LinkImpl(name, target));
            }
            return links;
        }

        private List<Alias> parseAliases(Element element) {
            assert (element != null);
            this.log.trace("Parse aliases; element; {}", (Object)element);
            ArrayList<Alias> aliases = new ArrayList<Alias>();
            List<Element> children = this.getChildElements(element, PluginParser.ALIAS);
            for (Element child : children) {
                String name = child.getAttribute(PluginParser.NAME);
                String alias = child.getAttribute(PluginParser.ALIAS);
                aliases.add(new AliasImpl(name, alias));
            }
            return aliases;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CommandType
    extends Enum<CommandType> {
        public static final /* enum */ CommandType STATELESS = new CommandType();
        public static final /* enum */ CommandType STATEFUL = new CommandType();
        private static final /* synthetic */ CommandType[] $VALUES;

        public static final CommandType[] values() {
            return (CommandType[])$VALUES.clone();
        }

        public static CommandType valueOf(String name) {
            return Enum.valueOf(CommandType.class, name);
        }

        public static CommandType parse(String text) {
            assert (text != null);
            return CommandType.valueOf(text.toUpperCase());
        }

        public String getTemplateName() {
            return this.name().toLowerCase() + PluginParser.COMMAND_TEMPLATE_SUFFIX;
        }

        public void wire(BeanDefinitionBuilder command, BeanDefinitionHolder action) {
            assert (command != null);
            assert (action != null);
            switch (this) {
                case STATELESS: {
                    command.addPropertyReference(PluginParser.ACTION, action.getBeanName());
                    break;
                }
                case STATEFUL: {
                    command.addPropertyValue(PluginParser.ACTION_ID, (Object)action.getBeanName());
                }
            }
        }

        static {
            $VALUES = new CommandType[]{STATELESS, STATEFUL};
        }
    }
}

