/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.plugin;

import java.util.HashSet;
import java.util.Set;
import org.apache.geronimo.gshell.application.Application;
import org.apache.geronimo.gshell.artifact.Artifact;
import org.apache.geronimo.gshell.wisdom.application.ApplicationArtifactFilter;

public class PluginArtifactFilter
extends ApplicationArtifactFilter {
    private final Set<String> excludes = new HashSet<String>();

    public PluginArtifactFilter(Application application) {
        assert (application != null);
        for (Artifact artifact : application.getClassPath().getArtifacts()) {
            String id = artifact.getGroup() + ":" + artifact.getName();
            this.excludes.add(id);
        }
    }

    public boolean accept(Artifact artifact) {
        if (super.accept(artifact)) {
            return !this.excludes.contains(artifact.getId());
        }
        return false;
    }
}

