/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.gshell.application.ClassPath;
import org.apache.geronimo.gshell.application.plugin.Plugin;
import org.apache.geronimo.gshell.application.plugin.activation.ActivationContext;
import org.apache.geronimo.gshell.application.plugin.activation.ActivationRule;
import org.apache.geronimo.gshell.application.plugin.activation.ActivationTask;
import org.apache.geronimo.gshell.application.plugin.bundle.Bundle;
import org.apache.geronimo.gshell.application.plugin.bundle.NoSuchBundleException;
import org.apache.geronimo.gshell.artifact.Artifact;
import org.apache.geronimo.gshell.spring.BeanContainer;
import org.apache.geronimo.gshell.spring.BeanContainerAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginImpl
implements Plugin,
BeanContainerAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String name;
    private Artifact artifact;
    private ClassPath classPath;
    private Map<String, String> bundleIdMap;
    private List<ActivationRule> activationRules;
    private BeanContainer container;

    public PluginImpl(String name) {
        assert (name != null);
        this.name = name;
    }

    @Override
    public void setBeanContainer(BeanContainer container) {
        assert (container != null);
        this.container = container;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Artifact getArtifact() {
        if (this.artifact == null) {
            throw new IllegalStateException("Artifact not initialized");
        }
        return this.artifact;
    }

    void initArtifact(Artifact artifact) {
        assert (artifact != null);
        this.artifact = artifact;
    }

    @Override
    public ClassPath getClassPath() {
        if (this.classPath == null) {
            throw new IllegalStateException("Classpath not initialized");
        }
        return this.classPath;
    }

    void initClassPath(ClassPath classPath) {
        assert (classPath != null);
        this.classPath = classPath;
    }

    @Override
    public Collection<String> getBundleNames() {
        Collection<Object> names = this.bundleIdMap == null ? Collections.emptyList() : this.bundleIdMap.keySet();
        return Collections.unmodifiableCollection(names);
    }

    public void setBundleIdMap(Map<String, String> bundleIdMap) {
        assert (bundleIdMap != null);
        this.bundleIdMap = bundleIdMap;
    }

    @Override
    public Bundle getBundle(String name) throws NoSuchBundleException {
        assert (name != null);
        assert (this.bundleIdMap != null);
        String id = this.bundleIdMap.get(name);
        if (id == null) {
            throw new NoSuchBundleException(name);
        }
        assert (this.container != null);
        return this.container.getBean(id, Bundle.class);
    }

    @Override
    public List<ActivationRule> getActivationRules() {
        return this.activationRules;
    }

    @Override
    public void setActivationRules(List<ActivationRule> rules) {
        assert (rules != null);
        this.activationRules = rules;
    }

    @Override
    public void activate() {
        if (this.activationRules == null) {
            this.log.warn("No activation rules configured");
            return;
        }
        ActivationContext context = new ActivationContext(){
            private List<ActivationTask> tasks = new ArrayList<ActivationTask>();

            @Override
            public Plugin getPlugin() {
                return PluginImpl.this;
            }

            @Override
            public List<ActivationTask> getTasks() {
                return this.tasks;
            }

            @Override
            public void addTask(ActivationTask task) {
                this.tasks.add(task);
            }
        };
        this.log.trace("Evaluating activation rules");
        for (ActivationRule rule : this.activationRules) {
            this.log.trace("Evaluating activation rule: {}", (Object)rule);
            try {
                rule.evaluate(context);
            }
            catch (Exception e) {
                this.log.warn("Failed to evaluate activation rule: " + rule, (Throwable)e);
            }
        }
        List<ActivationTask> tasks = context.getTasks();
        if (tasks.isEmpty()) {
            this.log.warn("No activation tasks configured in context");
            return;
        }
        this.log.trace("Executing activation tasks");
        for (ActivationTask task : tasks) {
            this.log.trace("Executing activation task: {}", (Object)task);
            try {
                task.execute();
            }
            catch (Exception e) {
                this.log.warn("Failed to execute activation task: " + task, (Throwable)e);
            }
        }
    }
}

