/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.plugin.bundle;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.gshell.command.Alias;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.Link;
import org.apache.geronimo.gshell.registry.AliasRegistry;
import org.apache.geronimo.gshell.registry.CommandRegistry;
import org.apache.geronimo.gshell.wisdom.command.LinkCommand;
import org.apache.geronimo.gshell.wisdom.plugin.bundle.BundleSupport;
import org.apache.geronimo.gshell.wisdom.registry.CommandLocationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandBundle
extends BundleSupport {
    private final CommandRegistry commandRegistry;
    private final AliasRegistry aliasRegistry;
    private List<Command> commands;
    private List<Link> links;
    private List<Alias> aliases;
    private List<Command> linkCommands;

    public CommandBundle(CommandRegistry commandRegistry, AliasRegistry aliasRegistry, String name) {
        super(name);
        assert (commandRegistry != null);
        this.commandRegistry = commandRegistry;
        assert (aliasRegistry != null);
        this.aliasRegistry = aliasRegistry;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public void setCommands(List<Command> commands) {
        assert (commands != null);
        this.commands = commands;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        assert (links != null);
        this.links = links;
    }

    public List<Alias> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<Alias> aliases) {
        assert (aliases != null);
        this.aliases = aliases;
    }

    @Override
    protected void doEnable() throws Exception {
        if (this.linkCommands == null) {
            this.linkCommands = new ArrayList<Command>();
            for (Link link : this.links) {
                LinkCommand cmd = new LinkCommand(this.commandRegistry, link.getTarget());
                cmd.setLocation(new CommandLocationImpl(link.getName()));
                this.linkCommands.add(cmd);
            }
        }
        for (Command command : this.commands) {
            this.commandRegistry.registerCommand(command);
        }
        for (Command command : this.linkCommands) {
            this.commandRegistry.registerCommand(command);
        }
        for (Alias alias : this.aliases) {
            this.aliasRegistry.registerAlias(alias.getName(), alias.getAlias());
        }
    }

    @Override
    protected void doDisable() throws Exception {
        for (Command command : this.commands) {
            this.commandRegistry.removeCommand(command);
        }
        for (Command command : this.linkCommands) {
            this.commandRegistry.removeCommand(command);
        }
        for (Alias alias : this.aliases) {
            this.aliasRegistry.removeAlias(alias.getName());
        }
    }
}

