/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.geronimo.gshell.event.EventPublisher;
import org.apache.geronimo.gshell.registry.AliasRegistry;
import org.apache.geronimo.gshell.registry.NoSuchAliasException;
import org.apache.geronimo.gshell.wisdom.registry.AliasRegisteredEvent;
import org.apache.geronimo.gshell.wisdom.registry.AliasRemovedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasRegistryImpl
implements AliasRegistry {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EventPublisher eventPublisher;
    private final Map<String, String> aliases = new LinkedHashMap<String, String>();

    public AliasRegistryImpl(EventPublisher eventPublisher) {
        assert (eventPublisher != null);
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void registerAlias(String name, String alias) {
        assert (name != null);
        assert (alias != null);
        this.log.debug("Registering alias: {} -> {}", (Object)name, (Object)alias);
        if (this.containsAlias(name)) {
            this.log.debug("Replacing alias: {}", (Object)name);
        }
        this.aliases.put(name, alias);
        this.eventPublisher.publish(new AliasRegisteredEvent(name, alias));
    }

    @Override
    public void removeAlias(String name) throws NoSuchAliasException {
        assert (name != null);
        this.log.debug("Removing alias: {}", (Object)name);
        if (!this.containsAlias(name)) {
            throw new NoSuchAliasException(name);
        }
        this.aliases.remove(name);
        this.eventPublisher.publish(new AliasRemovedEvent(name));
    }

    @Override
    public String getAlias(String name) throws NoSuchAliasException {
        assert (name != null);
        if (!this.containsAlias(name)) {
            throw new NoSuchAliasException(name);
        }
        return this.aliases.get(name);
    }

    @Override
    public boolean containsAlias(String name) {
        assert (name != null);
        return this.aliases.containsKey(name);
    }

    @Override
    public Collection<String> getAliasNames() {
        return Collections.unmodifiableSet(this.aliases.keySet());
    }
}

