/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.registry;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.shell.ShellContextHolder;
import org.apache.geronimo.gshell.vfs.FileSystemAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupDirectoryResolver {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FileSystemAccess fileSystemAccess;
    private FileObject commandsRoot;

    public GroupDirectoryResolver(FileSystemAccess fileSystemAccess) {
        assert (fileSystemAccess != null);
        this.fileSystemAccess = fileSystemAccess;
    }

    private FileObject getCommandsRoot() throws FileSystemException {
        if (this.commandsRoot == null) {
            this.commandsRoot = this.fileSystemAccess.createVirtualFileSystem("meta:/commands");
        }
        return this.commandsRoot;
    }

    public FileObject getGroupDirectory(Variables vars) throws FileSystemException {
        assert (vars != null);
        FileObject root = this.getCommandsRoot();
        FileObject dir = null;
        Object tmp = vars.get("gshell.group");
        if (tmp instanceof String) {
            this.log.trace("Resolving group directory from string: {}", tmp);
            dir = root.resolveFile((String)tmp);
        } else if (tmp != null) {
            this.log.error("Invalid type for variable 'gshell.group'; expected String; found: " + tmp.getClass());
        }
        if (dir == null) {
            dir = root;
        }
        return dir;
    }

    public FileObject getGroupDirectory() throws FileSystemException {
        return this.getGroupDirectory(ShellContextHolder.get().getVariables());
    }
}

