/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.shell;

import java.io.StringReader;
import org.apache.geronimo.gshell.commandline.CommandLine;
import org.apache.geronimo.gshell.commandline.CommandLineBuilder;
import org.apache.geronimo.gshell.commandline.CommandLineExecutor;
import org.apache.geronimo.gshell.io.Closer;
import org.apache.geronimo.gshell.notification.ErrorNotification;
import org.apache.geronimo.gshell.parser.ASTCommandLine;
import org.apache.geronimo.gshell.parser.CommandLineParser;
import org.apache.geronimo.gshell.parser.ParseException;
import org.apache.geronimo.gshell.parser.visitor.ExecutingVisitor;
import org.apache.geronimo.gshell.parser.visitor.LoggingVisitor;
import org.apache.geronimo.gshell.shell.ShellContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineBuilderImpl
implements CommandLineBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CommandLineParser parser;

    public CommandLineBuilderImpl(CommandLineParser parser) {
        assert (parser != null);
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ASTCommandLine parse(String input) throws ParseException {
        ASTCommandLine cl;
        assert (input != null);
        StringReader reader = new StringReader(input);
        try {
            cl = this.parser.parse(reader);
        }
        catch (Throwable throwable) {
            Closer.close(reader);
            throw throwable;
        }
        Closer.close(reader);
        if (this.log.isDebugEnabled()) {
            LoggingVisitor logger = new LoggingVisitor(this.log);
            cl.jjtAccept(logger, null);
        }
        return cl;
    }

    public CommandLine create(String line) throws ParseException {
        assert (line != null);
        this.log.debug("Building command-line for: {}", (Object)line);
        if (line.trim().length() == 0) {
            throw new IllegalArgumentException("Command line is empty");
        }
        try {
            final ASTCommandLine root = this.parse(line);
            return new CommandLine(){

                public Object execute(ShellContext context, CommandLineExecutor executor) throws Exception {
                    assert (context != null);
                    assert (executor != null);
                    ExecutingVisitor visitor = new ExecutingVisitor(context, executor);
                    return root.jjtAccept(visitor, null);
                }
            };
        }
        catch (Exception e) {
            throw new ErrorNotification(e);
        }
    }
}

