/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.shell;

import org.apache.geronimo.gshell.chronos.StopWatch;
import org.apache.geronimo.gshell.command.Arguments;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.CommandException;
import org.apache.geronimo.gshell.command.CommandResult;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.commandline.CommandLine;
import org.apache.geronimo.gshell.commandline.CommandLineBuilder;
import org.apache.geronimo.gshell.commandline.CommandLineExecutor;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.io.SystemOutputHijacker;
import org.apache.geronimo.gshell.notification.ErrorNotification;
import org.apache.geronimo.gshell.registry.CommandResolver;
import org.apache.geronimo.gshell.shell.ShellContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineExecutorImpl
implements CommandLineExecutor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CommandResolver commandResolver;
    private final CommandLineBuilder commandLineBuilder;

    public CommandLineExecutorImpl(CommandResolver commandResolver, CommandLineBuilder commandLineBuilder) {
        assert (commandResolver != null);
        this.commandResolver = commandResolver;
        assert (commandLineBuilder != null);
        this.commandLineBuilder = commandLineBuilder;
    }

    public Object execute(ShellContext context, String line) throws Exception {
        assert (context != null);
        assert (line != null);
        this.log.info("Executing (String): {}", (Object)line);
        try {
            CommandLine commandLine = this.commandLineBuilder.create(line);
            this.log.trace("Command-line: {}", (Object)commandLine);
            return commandLine.execute(context, this);
        }
        catch (ErrorNotification n) {
            Throwable cause = n.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw n;
        }
    }

    public Object execute(ShellContext context, Object ... args) throws Exception {
        assert (context != null);
        assert (args != null);
        this.log.info("Executing (Object...): [{}]", (Object)Arguments.asString(args));
        return this.doExecute(context, String.valueOf(args[0]), Arguments.shift(args));
    }

    public Object execute(ShellContext context, String path, Object[] args) throws Exception {
        assert (context != null);
        assert (path != null);
        assert (args != null);
        this.log.info("Executing ({}): [{}]", (Object)path, (Object)Arguments.asString(args));
        return this.doExecute(context, path, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute(ShellContext context, String path, Object[] args) throws Exception {
        CommandResult result;
        assert (context != null);
        this.log.debug("Executing");
        Variables vars = context.getVariables();
        Command command = this.commandResolver.resolveCommand(path, vars);
        IO io = context.getIo();
        SystemOutputHijacker.register(io.outputStream, io.errorStream);
        StopWatch watch = new StopWatch(true);
        try {
            result = command.execute(context, args);
            this.log.debug("Command completed with result: {}, after: {}", (Object)result, (Object)watch);
        }
        finally {
            SystemOutputHijacker.deregister();
            try {
                io.flush();
            }
            catch (Exception ignore) {}
        }
        if (result.hasNotified()) {
            throw result.getNotification();
        }
        if (result.hasFailed()) {
            throw new CommandException(result.getFailure());
        }
        return result.getValue();
    }
}

