/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.shell;

import org.apache.geronimo.gshell.console.Console;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.notification.ErrorNotification;
import org.apache.geronimo.gshell.shell.ShellContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleErrorHandlerImpl
implements Console.ErrorHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Console.ErrorHandler.Result handleError(Throwable error) {
        assert (error != null);
        this.displayError(error);
        return Console.ErrorHandler.Result.CONTINUE;
    }

    private void displayError(Throwable error) {
        assert (error != null);
        Throwable cause = error;
        if (error instanceof ErrorNotification) {
            cause = error.getCause();
        }
        IO io = ShellContextHolder.get().getIo();
        io.err.print("@|bold,red ERROR| ");
        io.err.print(cause.getClass().getSimpleName());
        io.err.println(": @|bold,red " + cause.getMessage() + "|");
        String stackTraceProperty = System.getProperty("gshell.show.stacktrace");
        boolean stackTraceFlag = false;
        if (stackTraceProperty != null) {
            stackTraceFlag = stackTraceProperty.trim().equals("true");
        }
        if (io.isDebug()) {
            this.log.debug(error.toString(), error);
        } else if (io.isVerbose() || stackTraceFlag) {
            StackTraceElement[] trace = cause.getStackTrace();
            StringBuilder buff = new StringBuilder();
            for (StackTraceElement e : trace) {
                buff.append("        @|bold at| ").append(e.getClassName()).append(".").append(e.getMethodName()).append(" (@|bold ");
                buff.append(e.isNativeMethod() ? "Native Method" : (e.getFileName() != null && e.getLineNumber() != -1 ? e.getFileName() + ":" + e.getLineNumber() : (e.getFileName() != null ? e.getFileName() : "Unknown Source")));
                buff.append("|)");
                io.err.println(buff);
                buff.setLength(0);
            }
        }
        io.err.flush();
    }
}

