/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.shell;

import org.apache.geronimo.gshell.ansi.AnsiRenderer;
import org.apache.geronimo.gshell.application.Application;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.console.Console;
import org.apache.geronimo.gshell.interpolation.VariablesValueSource;
import org.apache.geronimo.gshell.shell.ShellContextHolder;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsolePrompterImpl
implements Console.Prompter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Interpolator interp = new StringSearchInterpolator("%{", "}");
    private final VariablesValueSource variablesValueSource = new VariablesValueSource();
    private final AnsiRenderer renderer = new AnsiRenderer();
    private final String defaultPrompt;

    public ConsolePrompterImpl(Application application) {
        assert (application != null);
        this.interp.addValueSource(new PrefixedObjectValueSource("application", application));
        this.interp.addValueSource(new PrefixedObjectValueSource("branding", application.getModel().getBranding()));
        this.interp.addValueSource(this.variablesValueSource);
        this.defaultPrompt = application.getModel().getBranding().getPrompt();
    }

    public String prompt() {
        String prompt = null;
        Variables vars = ShellContextHolder.get().getVariables();
        String pattern = vars.get("gshell.prompt", String.class);
        if (pattern != null) {
            assert (this.variablesValueSource != null);
            this.variablesValueSource.setVariables(vars);
            try {
                assert (this.interp != null);
                prompt = this.interp.interpolate(pattern);
            }
            catch (InterpolationException e) {
                this.log.error("Failed to render prompt pattern: " + pattern, (Throwable)e);
            }
        }
        if (prompt == null) {
            prompt = this.defaultPrompt;
        }
        if (AnsiRenderer.test(prompt)) {
            prompt = this.renderer.render(prompt);
        }
        return prompt;
    }
}

