/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.core;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.geronimo.gshell.spring.BeanContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanContainerWrapper
implements BeanContainer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationContext context;

    public BeanContainerWrapper(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public BeanContainer getParent() {
        return null;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.context.getClassLoader();
    }

    @Override
    public void loadBeans(String[] strings) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getBean(Class<T> type) {
        assert (type != null);
        this.log.trace("Getting bean of type: {}", type);
        String[] names = this.context.getBeanNamesForType(type);
        if (names.length == 0) {
            throw new NoSuchBeanDefinitionException(type, "No bean defined for type: " + type);
        }
        if (names.length > 1) {
            throw new NoSuchBeanDefinitionException(type, "No unique bean defined for type: " + type + ", found matches: " + Arrays.asList(names));
        }
        return this.getBean(names[0], type);
    }

    @Override
    public <T> T getBean(String name, Class<T> requiredType) {
        assert (name != null);
        assert (requiredType != null);
        this.log.trace("Getting bean named '{}' of type: {}", (Object)name, requiredType);
        return (T)this.context.getBean(name, requiredType);
    }

    @Override
    public <T> Map<String, T> getBeans(Class<T> type) {
        assert (type != null);
        this.log.trace("Getting beans of type: {}", type);
        return this.context.getBeansOfType(type);
    }

    @Override
    public String[] getBeanNames() {
        this.log.trace("Getting bean names");
        return this.context.getBeanDefinitionNames();
    }

    @Override
    public String[] getBeanNames(Class type) {
        assert (type != null);
        this.log.trace("Getting bean names of type: {}", (Object)type);
        return this.context.getBeanNamesForType(type);
    }

    @Override
    public BeanContainer createChild(Collection<URL> urls) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BeanContainer createChild() {
        throw new UnsupportedOperationException();
    }
}

