/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.core;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.apache.geronimo.gshell.command.Alias;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.Link;
import org.apache.geronimo.gshell.registry.AliasRegistry;
import org.apache.geronimo.gshell.registry.CommandRegistry;
import org.apache.geronimo.gshell.wisdom.command.LinkCommand;
import org.apache.geronimo.gshell.wisdom.registry.CommandLocationImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.osgi.context.BundleContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandBundle
implements BundleContextAware,
InitializingBean,
DisposableBean,
ApplicationContextAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private CommandRegistry commandRegistry;
    private AliasRegistry aliasRegistry;
    private BundleContext bundleContext;
    private List<Command> commands;
    private List<Link> links;
    private List<Alias> aliases;
    private ApplicationContext applicationContext;
    private List<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public void setCommands(List<Command> commands) {
        assert (commands != null);
        this.commands = commands;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        assert (links != null);
        this.links = links;
    }

    public List<Alias> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<Alias> aliases) {
        assert (aliases != null);
        this.aliases = aliases;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void afterPropertiesSet() throws Exception {
        String[] names;
        this.log.debug("Initializing command bundle");
        if (this.commandRegistry == null && (names = this.applicationContext.getBeanNamesForType(CommandRegistry.class)).length == 1) {
            this.commandRegistry = (CommandRegistry)this.applicationContext.getBean(names[0], CommandRegistry.class);
        }
        if (this.aliasRegistry == null && (names = this.applicationContext.getBeanNamesForType(AliasRegistry.class)).length == 1) {
            this.aliasRegistry = (AliasRegistry)this.applicationContext.getBean(names[0], AliasRegistry.class);
        }
        if (this.commandRegistry != null && this.aliasRegistry != null) {
            this.log.debug("Command bundle is using the auto wired command/alias registry");
            if (this.commands != null) {
                for (Command command : this.commands) {
                    this.log.debug("Registering command: {}", (Object)command.getLocation());
                    this.commandRegistry.registerCommand(command);
                }
            }
            if (this.links != null) {
                for (Link link : this.links) {
                    this.log.debug("Registering link: {}", (Object)link.getName());
                    LinkCommand cmd = new LinkCommand(this.commandRegistry, link.getTarget());
                    cmd.setLocation(new CommandLocationImpl(link.getName()));
                    this.commandRegistry.registerCommand(cmd);
                }
            }
            if (this.aliases != null) {
                for (Alias alias : this.aliases) {
                    this.log.debug("Registering alias: {}", (Object)alias.getName());
                    this.aliasRegistry.registerAlias(alias.getName(), alias.getAlias());
                }
            }
        } else if (this.bundleContext != null) {
            Properties props;
            this.log.debug("Command bundle is using the OSGi registry");
            if (this.commands != null) {
                for (Command command : this.commands) {
                    this.log.debug("Registering command: {}", (Object)command.getLocation());
                    props = new Properties();
                    ((Dictionary)props).put("name", command.getLocation().getFullPath());
                    this.registrations.add(this.bundleContext.registerService(Command.class.getName(), (Object)command, (Dictionary)props));
                }
            }
            if (this.links != null) {
                for (Link link : this.links) {
                    this.log.debug("Registering link: {}", (Object)link.getName());
                    this.registrations.add(this.bundleContext.registerService(Link.class.getName(), (Object)link, (Dictionary)new Properties()));
                }
            }
            if (this.aliases != null) {
                for (Alias alias : this.aliases) {
                    this.log.debug("Registering alias: {}", (Object)alias.getName());
                    props = new Properties();
                    this.registrations.add(this.bundleContext.registerService(Alias.class.getName(), (Object)alias, (Dictionary)new Properties()));
                }
            }
        } else {
            throw new Exception("Command bundle should be wired to the command/alias registry or be used in an OSGi context");
        }
    }

    public void destroy() {
        this.log.debug("Destroying command bundle");
        for (ServiceRegistration reg : this.registrations) {
            reg.unregister();
        }
    }
}

