/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.core;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.geronimo.gshell.notification.ExitNotification;
import org.apache.geronimo.gshell.shell.Shell;
import org.apache.servicemix.kernel.main.spi.MainService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.osgi.context.BundleContextAware;

public class LocalConsole
implements Runnable,
BundleContextAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Shell shell;
    private boolean createLocalShell;
    private BundleContext bundleContext;
    private MainService mainService;
    private CountDownLatch frameworkStarted;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public MainService getMainService() {
        return this.mainService;
    }

    public void setMainService(MainService mainService) {
        this.mainService = mainService;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public boolean isCreateLocalShell() {
        return this.createLocalShell;
    }

    public void setCreateLocalShell(boolean createLocalShell) {
        this.createLocalShell = createLocalShell;
    }

    public void init() {
        this.shell.getContext().getVariables().set("gshell.username", "smx");
        this.frameworkStarted = new CountDownLatch(1);
        this.getBundleContext().addFrameworkListener(new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                LocalConsole.this.log.debug("Got event: " + event.getType());
                if (event.getType() == 1) {
                    LocalConsole.this.frameworkStarted.countDown();
                }
            }
        });
        if (this.createLocalShell) {
            new Thread((Runnable)this, "localShell").start();
        }
    }

    public void destroy() {
        if (this.createLocalShell) {
            this.shell.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object[] args = this.mainService.getArgs();
            if (args != null && args.length > 0) {
                this.waitForFrameworkToStart();
                this.log.info("Executing Shell with arguments: " + Arrays.toString(args));
                StringBuilder sb = new StringBuilder();
                for (Object arg : args) {
                    sb.append((String)arg).append(" ");
                }
                Object value = this.shell.execute(sb.toString());
                if (this.mainService != null) {
                    if (value instanceof Number) {
                        this.mainService.setExitCode(((Number)value).intValue());
                    } else {
                        this.mainService.setExitCode(value != null ? 1 : 0);
                    }
                    this.log.info("Exiting shell due to terminated command");
                }
            } else {
                this.shell.run(new Object[0]);
            }
        }
        catch (ExitNotification e) {
            if (this.mainService != null) {
                this.mainService.setExitCode(0);
            }
            this.log.info("Exiting shell due received exit notification");
        }
        catch (Throwable e) {
            if (this.mainService != null) {
                this.mainService.setExitCode(-1);
            }
            this.log.error("Exiting shell due to caught exception " + e, e);
        }
        finally {
            try {
                this.shell.close();
            }
            catch (Throwable t) {}
            this.asyncShutdown();
        }
    }

    private void waitForFrameworkToStart() throws InterruptedException {
        this.log.info("Waiting from framework to start.");
        if (this.frameworkStarted.await(60L, TimeUnit.SECONDS)) {
            this.log.info("System completed startup.");
        } else {
            this.log.warn("System took too long startup... continuing");
        }
    }

    private void asyncShutdown() {
        new Thread(){

            public void run() {
                try {
                    LocalConsole.this.getBundleContext().getBundle(0L).stop();
                }
                catch (BundleException e) {
                    LocalConsole.this.log.info("Caught exception while shutting down framework: " + (Object)((Object)e), (Throwable)e);
                }
            }
        }.start();
    }
}

