/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.geronimo.gshell.ansi.AnsiBuffer;
import org.apache.geronimo.gshell.ansi.AnsiCode;
import org.apache.geronimo.gshell.ansi.AnsiRenderWriter;
import org.apache.geronimo.gshell.application.model.Branding;

public class ServiceMixBranding
extends Branding {
    private String prompt;
    private String[] banner;
    private String displayName = "ServiceMix Kernel";
    private String displayVersion;
    private String displayLocation = "http://servicemix.apache.org/kernel/";
    private String applicationName;
    private String applicationVersion;
    private String applicationLocation;
    private String[] kernelBanner = new String[]{" ____                  _          __  __ _      ", "/ ___|  ___ _ ____   _(_) ___ ___|  \\/  (_)_  __", "\\___ \\ / _ \\ '__\\ \\ / / |/ __/ _ \\ |\\/| | \\ \\/ /", " ___) |  __/ |   \\ V /| | (_|  __/ |  | | |>  < ", "|____/ \\___|_|    \\_/ |_|\\___\\___|_|  |_|_/_/\\_\\"};

    public ServiceMixBranding() {
        this.banner = this.kernelBanner;
    }

    public void setEmbeddedResource(URL embeddedResource) {
        Properties brandProps = ServiceMixBranding.loadPropertiesFile(embeddedResource);
        String brandBanner = brandProps.getProperty("banner");
        int i = 0;
        int quot = 34;
        StringTokenizer st = new StringTokenizer(brandBanner, ",");
        this.banner = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            this.banner[i] = st.nextToken();
            this.banner[i] = this.banner[i].substring(1, this.banner[i].lastIndexOf(quot));
            ++i;
        }
        this.applicationName = brandProps.getProperty("application.name");
        this.applicationVersion = brandProps.getProperty("application.version");
        this.applicationLocation = brandProps.getProperty("application.location");
    }

    public String getName() {
        return "servicemix";
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setVersion(String version) {
        this.displayVersion = version;
    }

    public String getVersion() {
        return this.displayVersion;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getProgramName() {
        throw new UnsupportedOperationException();
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getAboutMessage() {
        StringWriter writer = new StringWriter();
        AnsiRenderWriter out = new AnsiRenderWriter(writer);
        out.println("For information about @|cyan " + this.displayName + "|, visit:");
        out.println("    @|bold " + this.displayLocation + "| ");
        out.flush();
        if (this.applicationName != null && this.applicationVersion != null) {
            out.println();
            out.println(this.applicationName + " " + this.applicationVersion);
            out.println();
            if (this.applicationLocation != null) {
                out.println("For information about @|cyan " + this.applicationName + "|, visit:");
                out.println("    @|bold " + this.applicationLocation + "| ");
                out.flush();
            }
        }
        return writer.toString();
    }

    public String getWelcomeMessage() {
        StringWriter writer = new StringWriter();
        AnsiRenderWriter out = new AnsiRenderWriter(writer);
        AnsiBuffer buff = new AnsiBuffer();
        for (String line : this.banner) {
            buff.attrib(line, AnsiCode.CYAN);
            out.println(buff);
        }
        out.println();
        out.println(" @|bold " + this.displayName + "| (" + this.displayVersion + ")");
        if (this.applicationName != null && this.applicationVersion != null) {
            out.println(" @|bold " + this.applicationName + "| (" + this.applicationVersion + ")");
        }
        out.println();
        out.println("Type '@|bold help|' for more information.");
        out.flush();
        return writer.toString();
    }

    private static Properties loadPropertiesFile(URL brandPropURL) {
        Properties brandProps = new Properties();
        InputStream is = null;
        try {
            is = brandPropURL.openConnection().getInputStream();
            brandProps.load(is);
            is.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            System.err.println("Error loading embedded properties from " + brandPropURL);
            System.err.println("ServicemixBranding: " + ex);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return null;
        }
        return brandProps;
    }
}

