/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.core;

import java.util.Iterator;
import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.command.CommandResult;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.commandline.CommandLineExecutor;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.shell.Shell;
import org.apache.geronimo.gshell.shell.ShellContext;
import org.apache.geronimo.gshell.shell.ShellContextHolder;
import org.apache.geronimo.gshell.wisdom.command.AliasCommand;
import org.apache.geronimo.gshell.wisdom.command.CommandSupport;

public class WorkAroundAliasCommand
extends AliasCommand {
    private final CommandLineExecutor executor;

    public WorkAroundAliasCommand(CommandLineExecutor executor) {
        super(executor);
        this.executor = executor;
        this.setAction(new AliasCommandAction());
    }

    protected void prepareAction(ShellContext context, Object[] args) {
        assert (context != null);
        assert (args != null);
        this.setAction(new AliasCommandAction());
        this.log.trace("Preparing action");
        IO io = context.getIo();
        CommandAction action = this.getAction();
        try {
            this.processArguments(io, action, args);
        }
        catch (Exception e) {
            throw new CommandSupport.AbortExecutionNotification(new CommandResult.FailureResult(e));
        }
    }

    private class AliasCommandAction
    implements CommandAction {
        @Argument
        private List<String> appendArgs = null;

        private AliasCommandAction() {
        }

        public Object execute(final CommandContext context) throws Exception {
            assert (context != null);
            StringBuilder buff = new StringBuilder();
            buff.append(WorkAroundAliasCommand.this.getAlias());
            if (this.appendArgs != null && !this.appendArgs.isEmpty()) {
                buff.append(" ");
                Iterator<String> iter = this.appendArgs.iterator();
                while (iter.hasNext()) {
                    buff.append('\"').append((Object)iter.next()).append('\"');
                    if (!iter.hasNext()) continue;
                    buff.append(" ");
                }
            }
            WorkAroundAliasCommand.this.log.debug("Executing alias: {}", (Object)buff);
            final Shell shell = ShellContextHolder.get().getShell();
            ShellContext shellContext = new ShellContext(){

                public Shell getShell() {
                    return shell;
                }

                public IO getIo() {
                    return context.getIo();
                }

                public Variables getVariables() {
                    return context.getVariables();
                }
            };
            Object result = WorkAroundAliasCommand.this.executor.execute(shellContext, buff.toString());
            WorkAroundAliasCommand.this.log.debug("Alias result: {}", result);
            return result;
        }
    }
}

