/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.audit.commands;

import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.servicemix.nmr.audit.AuditorMBean;
import org.apache.servicemix.nmr.audit.AuditorQueryMBean;
import org.apache.servicemix.nmr.audit.commands.AuditCommandSupport;

public class FindCommand
extends AuditCommandSupport {
    @Argument(required=true)
    String query;

    protected Object doExecute(AuditorMBean auditor) throws Exception {
        if (!(auditor instanceof AuditorQueryMBean)) {
            this.io.err.println("Auditor does not support search.  The auditor should be wrapped within a lucene auditor");
            return CommandAction.Result.FAILURE;
        }
        return this.doExecute((AuditorQueryMBean)auditor);
    }

    protected Object doExecute(AuditorQueryMBean auditor) throws Exception {
        String[] ids = auditor.findExchangesIdsByQuery(this.query);
        if (ids == null || ids.length == 0) {
            this.io.out.println("No matching exchanges");
        } else {
            for (String id : ids) {
                if (id == null) continue;
                this.io.out.println(id);
            }
        }
        return CommandAction.Result.SUCCESS;
    }
}

