/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.packages;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.servicemix.kernel.gshell.packages.PackageCommandSupport;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportsCommand
extends PackageCommandSupport {
    @Argument(required=false, multiValued=true, description="bundle ids")
    List<Long> ids;

    @Override
    protected void doExecute(PackageAdmin admin) throws Exception {
        ExportedPackage[] exported;
        HashMap<Long, ArrayList<ExportedPackage>> packages = new HashMap<Long, ArrayList<ExportedPackage>>();
        for (ExportedPackage pkg : exported = admin.getExportedPackages((Bundle)null)) {
            Bundle[] bundles = pkg.getImportingBundles();
            if (bundles == null) continue;
            for (Bundle b : bundles) {
                ArrayList<ExportedPackage> p = (ArrayList<ExportedPackage>)packages.get(b.getBundleId());
                if (p == null) {
                    p = new ArrayList<ExportedPackage>();
                    packages.put(b.getBundleId(), p);
                }
                p.add(pkg);
            }
        }
        if (this.ids != null && !this.ids.isEmpty()) {
            for (long id : this.ids) {
                Bundle bundle = this.getBundleContext().getBundle(id);
                if (bundle != null) {
                    this.printImports(this.io.out, bundle, (List)packages.get(bundle.getBundleId()));
                    continue;
                }
                this.io.err.println("Bundle ID " + id + " is invalid.");
            }
        } else {
            ArrayList<ExportedPackage> pkgs = new ArrayList<ExportedPackage>();
            for (List l : packages.values()) {
                pkgs.addAll(l);
            }
            this.printImports(this.io.out, null, pkgs);
        }
    }

    protected void printImports(PrintWriter out, Bundle target, List<ExportedPackage> imports) {
        if (imports != null && imports.size() > 0) {
            for (ExportedPackage p : imports) {
                Bundle bundle = p.getExportingBundle();
                out.print(ImportsCommand.getBundleName(bundle));
                out.println(": " + p);
            }
        } else {
            out.println(ImportsCommand.getBundleName(target) + ": No active imported packages.");
        }
    }

    public static String getBundleName(Bundle bundle) {
        if (bundle != null) {
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            return name == null ? "Bundle " + Long.toString(bundle.getBundleId()) : name + " (" + Long.toString(bundle.getBundleId()) + ")";
        }
        return "[STALE BUNDLE]";
    }
}

